/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.db.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateWizard;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateDSVPage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateModel;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateQueryPage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateStructurePage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateTypePage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.Messages;
import org.eclipse.jface.wizard.IWizardPage;

public class DataStructureTemplateWizard
extends TemplateWizard {
    private final DataStructureTemplateModel model;
    private final DataStructureTemplateTypePage typesPage;
    private final DataStructureTemplateStructurePage structurePage;
    private final DataStructureTemplateQueryPage queryPage;
    private final DataStructureTemplateDSVPage dsvPage;
    private final DataStructureTemplateTargetLocationPage targetLocationPage;

    public DataStructureTemplateWizard(IResource resource) {
        this.setWindowTitle(Messages.DataStructureTemplateWizard_CREATE_DATA_STRUCTURE);
        this.model = new DataStructureTemplateModel();
        this.model.setSourceResource(resource);
        this.typesPage = new DataStructureTemplateTypePage(this.model);
        this.structurePage = new DataStructureTemplateStructurePage(this.model);
        this.queryPage = new DataStructureTemplateQueryPage(this.model);
        this.dsvPage = new DataStructureTemplateDSVPage(this.model);
        this.targetLocationPage = new DataStructureTemplateTargetLocationPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typesPage);
        this.addPage((IWizardPage)this.structurePage);
        this.addPage((IWizardPage)this.queryPage);
        this.addPage((IWizardPage)this.dsvPage);
        this.addPage((IWizardPage)this.targetLocationPage);
    }

    public TemplateGenerator getTemplateGenerator() {
        DataStructureTemplateGenerator generator = new DataStructureTemplateGenerator(this.model);
        return generator;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        Object nextPage = null;
        if (page instanceof DataStructureTemplateTypePage) {
            if ("/org/eclipse/dirigible/ide/template/ui/db/templates/table.table".equals(this.model.getTemplate().getLocation())) {
                nextPage = this.structurePage;
            } else if ("/org/eclipse/dirigible/ide/template/ui/db/templates/view.view".equals(this.model.getTemplate().getLocation())) {
                nextPage = this.queryPage;
            } else if ("/org/eclipse/dirigible/ide/template/ui/db/templates/dsv.dsv".equals(this.model.getTemplate().getLocation())) {
                nextPage = this.dsvPage;
            }
        } else {
            nextPage = page instanceof DataStructureTemplateStructurePage || page instanceof DataStructureTemplateDSVPage ? this.targetLocationPage : super.getNextPage(page);
        }
        return nextPage;
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }
}

