/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.MapTypeDecl;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TypesJavaGenerator {
    protected static final List<String> packageFragments = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org", "eclipse", "comma", "monitoring", "generated"}));
    protected static final String rootPackage = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("org.eclipse.comma.monitoring.lib");
            return _builder.toString();
        }
    }.apply();

    protected static CharSequence generatedPackage() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _join = IterableExtensions.join(packageFragments, (CharSequence)".");
        _builder.append(_join);
        _builder.append(";");
        return _builder;
    }

    protected static String generatedFileName(String name) {
        String _join = IterableExtensions.join(packageFragments, (CharSequence)File.separator);
        String _plus = String.valueOf(_join) + File.separator;
        String _plus_1 = String.valueOf(_plus) + name;
        return String.valueOf(_plus_1) + ".java";
    }

    protected CharSequence _defaultValue(SimpleTypeDecl t) {
        boolean _tripleNotEquals;
        boolean _equals = t.getName().equals("int");
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("0L");
            return _builder;
        }
        boolean _equals_1 = t.getName().equals("bool");
        if (_equals_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("true");
            return _builder_1;
        }
        boolean _equals_2 = t.getName().equals("string");
        if (_equals_2) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("\"\"");
            return _builder_2;
        }
        boolean _equals_3 = t.getName().equals("real");
        if (_equals_3) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("0.0");
            return _builder_3;
        }
        boolean _equals_4 = t.getName().equals("bulkdata");
        if (_equals_4) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("new CBulkdata(0)");
            return _builder_4;
        }
        boolean _equals_5 = t.getName().equals("id");
        if (_equals_5) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("\"\"");
            return _builder_5;
        }
        SimpleTypeDecl _base = t.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            return this.defaultValue((EObject)t.getBase());
        }
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("null");
        return _builder_6;
    }

    protected CharSequence _defaultValue(EnumTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        CharSequence _javaType = this.toJavaType((EObject)t);
        _builder.append((Object)_javaType);
        _builder.append("(\"");
        String _name = t.getName();
        _builder.append(_name);
        _builder.append("::");
        String _name_1 = ((EnumElement)t.getLiterals().get(0)).getName();
        _builder.append(_name_1);
        _builder.append("\")");
        return _builder;
    }

    protected CharSequence _defaultValue(TypeReference t) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _defaultValue = this.defaultValue((EObject)t.getType());
        _builder.append((Object)_defaultValue);
        return _builder;
    }

    protected CharSequence _defaultValue(RecordTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        CharSequence _javaType = this.toJavaType((EObject)t);
        _builder.append((Object)_javaType);
        _builder.append("(\"");
        String _string = CommaUtilities.getFullyQualifiedName((NamedElement)t).toString("_");
        _builder.append(_string);
        _builder.append("\")");
        List _reverseView = ListExtensions.reverseView((List)TypeUtilities.getAllFields((RecordTypeDecl)t));
        for (RecordField f : _reverseView) {
            _builder.append(".setValueOfField(\"");
            String _name = f.getName();
            _builder.append(_name);
            _builder.append("\", ");
            CharSequence _defaultValue = this.defaultValue((EObject)f.getType());
            _builder.append((Object)_defaultValue);
            _builder.append(")");
        }
        return _builder;
    }

    protected CharSequence _defaultValue(VectorTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        CharSequence _javaType = this.toJavaType((EObject)t);
        _builder.append((Object)_javaType);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _defaultValue(VectorTypeConstructor t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        CharSequence _javaType = this.toJavaType((EObject)t);
        _builder.append((Object)_javaType);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _defaultValue(MapTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        CharSequence _javaType = this.toJavaType((EObject)t);
        _builder.append((Object)_javaType);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _defaultValue(MapTypeConstructor t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new ");
        CharSequence _javaType = this.toJavaType((EObject)t);
        _builder.append((Object)_javaType);
        _builder.append("()");
        return _builder;
    }

    protected CharSequence _toJavaType(EnumTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CEnumValue");
        return _builder;
    }

    protected CharSequence _toJavaType(SimpleTypeDecl t) {
        boolean _tripleNotEquals;
        boolean _equals = t.getName().equals("int");
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("long");
            return _builder;
        }
        boolean _equals_1 = t.getName().equals("bool");
        if (_equals_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("boolean");
            return _builder_1;
        }
        boolean _equals_2 = t.getName().equals("string");
        if (_equals_2) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("String");
            return _builder_2;
        }
        boolean _equals_3 = t.getName().equals("real");
        if (_equals_3) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("double");
            return _builder_3;
        }
        boolean _equals_4 = t.getName().equals("bulkdata");
        if (_equals_4) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("CBulkdata");
            return _builder_4;
        }
        boolean _equals_5 = t.getName().equals("id");
        if (_equals_5) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("String");
            return _builder_5;
        }
        SimpleTypeDecl _base = t.getBase();
        boolean bl = _tripleNotEquals = _base != null;
        if (_tripleNotEquals) {
            return this.toJavaType((EObject)t.getBase());
        }
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("Object");
        return _builder_6;
    }

    protected CharSequence _toJavaType(TypeReference t) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _javaType = this.toJavaType((EObject)t.getType());
        _builder.append((Object)_javaType);
        return _builder;
    }

    protected CharSequence _toJavaType(RecordTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CRecord");
        return _builder;
    }

    protected CharSequence _toJavaType(VectorTypeDecl t) {
        return this.toJavaType((EObject)t.getConstructor());
    }

    protected CharSequence _toJavaType(VectorTypeConstructor t) {
        CharSequence _xblockexpression = null;
        CharSequence result = this.toJavaReferenceType((EObject)TypeUtilities.getBaseType((TypeObject)t));
        int i = 0;
        while (i < t.getDimensions().size()) {
            result = "CVector<" + result + ">";
            ++i;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected CharSequence _toJavaType(MapTypeDecl t) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _javaType = this.toJavaType((EObject)t.getConstructor());
        _builder.append((Object)_javaType);
        return _builder;
    }

    protected CharSequence _toJavaType(MapTypeConstructor t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CMap<");
        CharSequence _javaReferenceType = this.toJavaReferenceType((EObject)t.getType());
        _builder.append((Object)_javaReferenceType);
        _builder.append(", ");
        CharSequence _javaReferenceType_1 = this.toJavaReferenceType((EObject)t.getValueType());
        _builder.append((Object)_javaReferenceType_1);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _toJavaReferenceType(Type t) {
        CharSequence _xifexpression = null;
        _xifexpression = t instanceof TypeReference ? this.toJavaReferenceType((EObject)((TypeReference)t).getType()) : this.toJavaType((EObject)t);
        return _xifexpression;
    }

    protected CharSequence _toJavaReferenceType(TypeDecl t) {
        block17: {
            String _name = t.getName();
            if (_name == null) break block17;
            switch (_name) {
                case "int": {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("Long");
                    return _builder;
                }
                case "bool": {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Boolean");
                    return _builder_1;
                }
                case "real": {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("Double");
                    return _builder_2;
                }
            }
            if (t instanceof SimpleTypeDecl) {
                boolean _tripleNotEquals;
                SimpleTypeDecl _base = ((SimpleTypeDecl)t).getBase();
                boolean bl = _tripleNotEquals = _base != null;
                if (_tripleNotEquals) {
                    return this.toJavaReferenceType((EObject)((SimpleTypeDecl)t).getBase());
                }
            }
            return this.toJavaType((EObject)t);
        }
        if (t instanceof SimpleTypeDecl) {
            boolean _tripleNotEquals;
            SimpleTypeDecl _base = ((SimpleTypeDecl)t).getBase();
            boolean bl = _tripleNotEquals = _base != null;
            if (_tripleNotEquals) {
                return this.toJavaReferenceType((EObject)((SimpleTypeDecl)t).getBase());
            }
        }
        return this.toJavaType((EObject)t);
    }

    public CharSequence defaultValue(EObject t) {
        if (t instanceof EnumTypeDecl) {
            return this._defaultValue((EnumTypeDecl)t);
        }
        if (t instanceof MapTypeDecl) {
            return this._defaultValue((MapTypeDecl)t);
        }
        if (t instanceof RecordTypeDecl) {
            return this._defaultValue((RecordTypeDecl)t);
        }
        if (t instanceof SimpleTypeDecl) {
            return this._defaultValue((SimpleTypeDecl)t);
        }
        if (t instanceof VectorTypeDecl) {
            return this._defaultValue((VectorTypeDecl)t);
        }
        if (t instanceof MapTypeConstructor) {
            return this._defaultValue((MapTypeConstructor)t);
        }
        if (t instanceof TypeReference) {
            return this._defaultValue((TypeReference)t);
        }
        if (t instanceof VectorTypeConstructor) {
            return this._defaultValue((VectorTypeConstructor)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }

    public CharSequence toJavaType(EObject t) {
        if (t instanceof EnumTypeDecl) {
            return this._toJavaType((EnumTypeDecl)t);
        }
        if (t instanceof MapTypeDecl) {
            return this._toJavaType((MapTypeDecl)t);
        }
        if (t instanceof RecordTypeDecl) {
            return this._toJavaType((RecordTypeDecl)t);
        }
        if (t instanceof SimpleTypeDecl) {
            return this._toJavaType((SimpleTypeDecl)t);
        }
        if (t instanceof VectorTypeDecl) {
            return this._toJavaType((VectorTypeDecl)t);
        }
        if (t instanceof MapTypeConstructor) {
            return this._toJavaType((MapTypeConstructor)t);
        }
        if (t instanceof TypeReference) {
            return this._toJavaType((TypeReference)t);
        }
        if (t instanceof VectorTypeConstructor) {
            return this._toJavaType((VectorTypeConstructor)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }

    public CharSequence toJavaReferenceType(EObject t) {
        if (t instanceof TypeDecl) {
            return this._toJavaReferenceType((TypeDecl)t);
        }
        if (t instanceof Type) {
            return this._toJavaReferenceType((Type)t);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t).toString());
    }
}

