/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.messages;

import org.eclipse.comma.monitoring.lib.CState;
import org.eclipse.comma.monitoring.lib.messages.CMessage;
import org.eclipse.comma.monitoring.lib.utils.Utils;

public class CObservedMessage
extends CMessage {
    protected String messageId = "";
    protected double timeDelta = 0.0;
    protected String timestamp = "";
    protected String interfaceName = "";
    protected CState interfaceState = null;

    public CObservedMessage() {
    }

    public CObservedMessage(String name, String source, String destination, String sourcePort, String destinationPort) {
        super(name, source, destination, sourcePort, destinationPort);
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setInterface(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public void setTimeDelta(double timeDelta) {
        this.timeDelta = timeDelta;
    }

    public double getTimeDelta() {
        return this.timeDelta;
    }

    public CObservedMessage setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public CState getInterfaceState() {
        return this.interfaceState;
    }

    public CObservedMessage setInterfaceState(CState interfaceState) {
        this.interfaceState = interfaceState;
        return this;
    }

    public CObservedMessage clone() {
        return ((CObservedMessage)Utils.deepCopy(this)).clearState();
    }

    public CObservedMessage clearState() {
        this.states.clear();
        return this;
    }

    public String toString() {
        return this.messageId.length() == 0 ? "" : "[" + this.messageId + "] ";
    }

    public String printStringWithState() {
        String result = this.toString();
        if (!this.states.isEmpty()) {
            result = "State: " + (String)this.states.get(0) + " " + result;
        }
        return result;
    }

    public String printUMLWithState() {
        String result = this.printUML();
        if (!this.states.isEmpty()) {
            result = String.valueOf(result) + "\n" + "note left: State " + (String)this.states.get(1);
        }
        return result;
    }

    public String printUMLWithTime() {
        String result = String.valueOf(this.printUML()) + " at time " + this.timestamp;
        return result;
    }

    public String printUMLWithTimeAndState() {
        String result = this.printUMLWithTime();
        if (!this.states.isEmpty()) {
            result = String.valueOf(result) + "\n" + "note left: State " + (String)this.states.get(0);
        }
        return result;
    }

    public String printUMLParameters() {
        String result = "(";
        int i = 0;
        while (i < this.getParameters().size()) {
            if (i >= 1) {
                result = String.valueOf(result) + ", ";
            }
            String parameter = this.getParameters().get(i).toString();
            result = String.valueOf(result) + parameter;
            ++i;
        }
        return String.valueOf(result) + ")";
    }

    public String printUML() {
        return "";
    }
}

