/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record.emf;

import java.io.IOException;
import org.apache.poi.hemf.draw.HemfGraphics;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hemf.record.emf.HemfRecordType;
import org.apache.poi.hwmf.record.HwmfPalette;
import org.apache.poi.util.LittleEndianInputStream;

public class HemfPalette {

    public static class EmfRealizePalette
    extends HwmfPalette.WmfRealizePalette
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.realizePalette;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            return 0L;
        }
    }

    public static class EmfResizePalette
    extends HwmfPalette.WmfResizePalette
    implements HemfRecord {
        int paletteIndex;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.resizePalette;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.paletteIndex = (int)leis.readUInt();
            this.numberOfEntries = (int)leis.readUInt();
            return 8L;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.addObjectTableEntry(this, this.paletteIndex);
        }
    }

    public static class EmfSetPaletteEntries
    extends HwmfPalette.WmfSetPaletteEntries
    implements HemfRecord {
        int paletteIndex;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.setPaletteEntries;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.paletteIndex = (int)leis.readUInt();
            this.start = (int)leis.readUInt();
            int nbrOfEntries = (int)leis.readUInt();
            int size = this.readPaletteEntries(leis, nbrOfEntries);
            return size + 12;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.addObjectTableEntry(this, this.paletteIndex);
        }
    }

    public static class EmfCreatePalette
    extends HwmfPalette.WmfCreatePalette
    implements HemfRecord {
        protected int paletteIndex;

        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.createPalette;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.start = 768;
            this.paletteIndex = (int)leis.readUInt();
            int version = leis.readUShort();
            assert (version == 768);
            int size = this.readPaletteEntries(leis, -1);
            return size + 4 + 2;
        }

        @Override
        public void draw(HemfGraphics ctx) {
            ctx.addObjectTableEntry(this, this.paletteIndex);
        }
    }

    public static class EmfSelectPalette
    extends HwmfPalette.WmfSelectPalette
    implements HemfRecord {
        @Override
        public HemfRecordType getEmfRecordType() {
            return HemfRecordType.selectPalette;
        }

        @Override
        public long init(LittleEndianInputStream leis, long recordSize, long recordId) throws IOException {
            this.paletteIndex = (int)leis.readUInt();
            return 4L;
        }
    }
}

