/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingBindingsListener;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.WorkbenchJob;

public class CreateRendering
extends AbstractMemoryRendering
implements IMemoryRenderingBindingsListener {
    private ListViewer fViewer;
    private Label fMemoryBlockLabel;
    private IMemoryRenderingContainer fContainer;
    private Composite fCanvas;
    private String fLabel;
    private String fTabLabel;

    public CreateRendering(IMemoryRenderingContainer container) {
        super("org.eclipse.debug.internal.ui.views.createrendering");
        this.fContainer = container;
    }

    @Override
    public Control createControl(Composite parent) {
        this.fCanvas = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 2;
        compositeLayout.makeColumnsEqualWidth = false;
        this.fCanvas.setLayout((Layout)compositeLayout);
        GridData comositeSpec = new GridData();
        comositeSpec.grabExcessVerticalSpace = true;
        comositeSpec.grabExcessHorizontalSpace = true;
        comositeSpec.horizontalAlignment = 4;
        comositeSpec.verticalAlignment = 2;
        this.fCanvas.setLayoutData((Object)comositeSpec);
        this.fMemoryBlockLabel = new Label(this.fCanvas, 2048);
        String memoryBlockLabel = " ";
        memoryBlockLabel = this.getLabel();
        this.fMemoryBlockLabel.setText("  " + DebugUIMessages.CreateRenderingTab_Memory_monitor + memoryBlockLabel + "  ");
        GridData textLayout = new GridData();
        textLayout.verticalAlignment = 2;
        textLayout.horizontalAlignment = 1;
        this.fMemoryBlockLabel.setLayoutData((Object)textLayout);
        Label renderingLabel = new Label(this.fCanvas, 0);
        renderingLabel.setText(DebugUIMessages.CreateRenderingTab_Select_renderings_to_create);
        GridData renderingLayout = new GridData();
        renderingLayout.horizontalAlignment = 1;
        renderingLayout.verticalAlignment = 2;
        renderingLayout.horizontalSpan = 2;
        renderingLabel.setLayoutData((Object)renderingLayout);
        this.fViewer = new ListViewer(this.fCanvas);
        this.fViewer.setContentProvider((IContentProvider)new MemoryRenderingContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MemoryRenderingLabelProvider());
        this.fViewer.setInput((Object)this.getMemoryBlock());
        if (this.fViewer.getElementAt(0) != null) {
            this.fViewer.getList().select(0);
        }
        GridData listLayout = new GridData(1808);
        listLayout.horizontalSpan = 1;
        this.fViewer.getControl().setLayoutData((Object)listLayout);
        this.fViewer.addDoubleClickListener(event -> this.addRenderings());
        this.fViewer.getList().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    CreateRendering.this.addRenderings();
                }
            }
        });
        Button addButton = new Button(this.fCanvas, 0);
        addButton.setText(DebugUIMessages.CreateRenderingTab_Add_renderings);
        GridData buttonLayout = new GridData();
        buttonLayout.horizontalAlignment = 1;
        buttonLayout.verticalAlignment = 1;
        addButton.setLayoutData((Object)buttonLayout);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateRendering.this.addRenderings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CreateRendering.this.addRenderings();
            }
        });
        DebugUITools.getMemoryRenderingManager().addListener(this);
        return this.fCanvas;
    }

    private void addRenderings() {
        ISelection selection = this.fViewer.getSelection();
        Object[] renderings = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            renderings = strucSelection.toArray();
        }
        if (renderings == null) {
            Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5013, DebugUIMessages.CreateRenderingTab_0, null);
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), DebugUIMessages.CreateRenderingTab_1, DebugUIMessages.CreateRenderingTab_2, (IStatus)stat);
            return;
        }
        IMemoryBlockRetrieval standardMemRetrieval = MemoryViewUtil.getMemoryBlockRetrieval(this.getMemoryBlock());
        if (standardMemRetrieval == null) {
            return;
        }
        IMemoryRenderingContainer container = this.fContainer;
        Object[] objectArray = renderings;
        int n = renderings.length;
        int n2 = 0;
        while (n2 < n) {
            Object r = objectArray[n2];
            if (r instanceof IMemoryRenderingType) {
                try {
                    IMemoryRendering rendering = ((IMemoryRenderingType)r).createRendering();
                    if (rendering != null) {
                        rendering.init(container, this.getMemoryBlock());
                        container.addMemoryRendering(rendering);
                    }
                }
                catch (CoreException e) {
                    MemoryViewUtil.openError(DebugUIMessages.CreateRendering_0, DebugUIMessages.CreateRendering_1, (Exception)((Object)e));
                }
            }
            ++n2;
        }
    }

    @Override
    public void dispose() {
        this.fViewer = null;
        this.fCanvas = null;
        this.fContainer = null;
        this.fMemoryBlockLabel = null;
        DebugUITools.getMemoryRenderingManager().removeListener(this);
    }

    @Override
    public Control getControl() {
        return this.fCanvas;
    }

    @Override
    public void memoryRenderingBindingsChanged() {
        if (this.fViewer != null) {
            this.fViewer.refresh();
        }
    }

    @Override
    public String getLabel() {
        if (this.fTabLabel == null) {
            this.fTabLabel = DebugUIMessages.CreateRendering_2;
            this.updateRenderingLabel();
        }
        return this.fTabLabel;
    }

    @Override
    public Image getImage() {
        return DebugUIPlugin.getImageDescriptorRegistry().get(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
    }

    @Override
    public void becomesVisible() {
    }

    @Override
    public void becomesHidden() {
    }

    protected void updateRenderingLabel() {
        Job job = new Job("Update Rendering Label"){

            protected IStatus run(IProgressMonitor monitor) {
                CreateRendering.this.fLabel = CreateRendering.super.getLabel();
                CreateRendering.this.fTabLabel = DebugUIMessages.CreateRenderingTab_label;
                CreateRendering.this.firePropertyChangedEvent(new PropertyChangeEvent((Object)CreateRendering.this, "org.eclipse.jface.text", null, (Object)CreateRendering.this.fTabLabel));
                WorkbenchJob wbJob = new WorkbenchJob("Create Rendering Update Label"){

                    public IStatus runInUIThread(IProgressMonitor wbMonitor) {
                        if (CreateRendering.this.fMemoryBlockLabel != null) {
                            CreateRendering.this.fMemoryBlockLabel.setText(String.valueOf(DebugUIMessages.CreateRenderingTab_Memory_monitor) + " " + CreateRendering.this.fLabel);
                            CreateRendering.this.fMemoryBlockLabel.getParent().layout();
                        }
                        return Status.OK_STATUS;
                    }
                };
                wbJob.setSystem(true);
                wbJob.schedule();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    class MemoryRenderingContentProvider
    implements IStructuredContentProvider {
        MemoryRenderingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] renderings = DebugUITools.getMemoryRenderingManager().getRenderingTypes((IMemoryBlock)inputElement);
            return renderings;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class MemoryRenderingLabelProvider
    implements ILabelProvider {
        MemoryRenderingLabelProvider() {
        }

        public Image getImage(Object element) {
            return DebugUIPlugin.getImageDescriptorRegistry().get(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
        }

        public String getText(Object element) {
            if (element instanceof IMemoryRenderingType) {
                String label = ((IMemoryRenderingType)element).getLabel();
                return label;
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

