/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.command.recorder.ui.view;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.capella.command.recorder.core.exception.RecorderException;
import org.polarsys.capella.command.recorder.core.manager.AbstractRecorderManager;
import org.polarsys.capella.command.recorder.core.output.OutputHelper;
import org.polarsys.capella.command.recorder.ui.messages.CapellaRecorderUIMessages;
import org.polarsys.capella.command.recorder.ui.view.ImportRecordAction;
import org.polarsys.capella.command.recorder.ui.view.RecorderSharedImages;

public abstract class AbstractRecorderView
extends ViewPart {
    protected TreeViewer _treeViewer = null;
    protected String _fDirectory = OutputHelper.getRootDirectoryForStorage().getPath();

    protected abstract boolean loadRecord(File var1);

    protected abstract AbstractRecorderManager getRecorderManager();

    protected abstract ITreeContentProvider getContentProvider();

    protected abstract ITableLabelProvider getLabelProvider();

    protected abstract TreeViewer createTreeViewer(Composite var1);

    public boolean loadRecord(String path) {
        return this.loadRecord(new Path(path).toFile());
    }

    public String selectRecord() {
        FileDialog dialog = new FileDialog(this.getViewSite().getShell());
        dialog.setFilterExtensions(new String[]{"*.log"});
        String directory = this._fDirectory != null ? this._fDirectory : OutputHelper.getRootDirectoryForStorage().getPath();
        File file = new File(directory);
        if (!file.exists()) {
            file.mkdir();
        }
        dialog.setFilterPath(directory);
        String path = dialog.open();
        if (path != null) {
            this.loadRecord(path);
            this._fDirectory = new Path(path).removeLastSegments(1).toString();
        }
        return path;
    }

    public void createPartControl(Composite parent) {
        this._treeViewer = this.createTreeViewer(parent);
        this.createActions();
        this._treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this._treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
    }

    protected void createActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = bars.getToolBarManager();
        Action importLogAction = this.createImportRecordAction();
        Action deleteLogs = this.createDeleteLogsAction();
        toolBarManager.add((IAction)importLogAction);
        toolBarManager.add((IAction)deleteLogs);
    }

    protected Action createImportRecordAction() {
        ImportRecordAction action = new ImportRecordAction(this, "");
        action.setToolTipText(CapellaRecorderUIMessages.recorderView_loadFileMainButton);
        action.setImageDescriptor(RecorderSharedImages.getImageDescriptor("eaction16/import_records.gif"));
        action.setDisabledImageDescriptor(RecorderSharedImages.getImageDescriptor("daction16/import_records.gif"));
        return action;
    }

    protected Action createDeleteLogsAction() {
        Action action = new Action(CapellaRecorderUIMessages.recorderView_deleteButton){

            public void run() {
                String title = CapellaRecorderUIMessages.recorderView_confirmDelete_title;
                String message = CapellaRecorderUIMessages.recorderView_confirmDelete_msg;
                if (!MessageDialog.openConfirm((Shell)AbstractRecorderView.this._treeViewer.getTree().getShell(), (String)title, (String)message)) {
                    return;
                }
                AbstractRecorderManager mgr = AbstractRecorderView.this.getRecorderManager();
                boolean oldState = mgr.isStarted();
                if (oldState) {
                    try {
                        mgr.shutDown();
                    }
                    catch (RecorderException recorderException) {
                        // empty catch block
                    }
                }
                File root = OutputHelper.getRootDirectoryForStorage();
                OutputHelper.deleteFiles((File[])root.listFiles());
                AbstractRecorderView.this._treeViewer.setInput(null);
                if (oldState) {
                    try {
                        mgr.startup();
                    }
                    catch (RecorderException recorderException) {
                        // empty catch block
                    }
                }
            }
        };
        action.setToolTipText(CapellaRecorderUIMessages.recorderView_deleteButton_toolTip);
        action.setImageDescriptor(RecorderSharedImages.getImageDescriptor("view16/delete.gif"));
        action.setDisabledImageDescriptor(RecorderSharedImages.getImageDescriptor("view16/delete.gif"));
        action.setEnabled(true);
        return action;
    }

    public void setFocus() {
    }
}

