/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.view.actions;

import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.ocl.requester.internal.l10n.OCLInterpreterMessages;
import org.polarsys.capella.ocl.requester.view.actions.OCLInterpreterViewAction;

public class ExportResultAction
extends OCLInterpreterViewAction {
    private final String tip = OCLInterpreterMessages.OCLInterpreterView_exportResultAction_tip;

    public ExportResultAction() {
        super(OCLInterpreterMessages.OCLInterpreterView_exportResultAction_label, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
    }

    public String getToolTipText() {
        return this.tip;
    }

    @Override
    public void run() {
        super.run();
        Shell shell = this.view.getPage().getShell();
        if (this.view.getLastOCLExpression() != null) {
            FileDialog dlg = new FileDialog(shell, 8192);
            dlg.setFilterExtensions(new String[]{"*.csv"});
            dlg.setText(OCLInterpreterMessages.OCLInterpreterView_exportResultDlg_title);
            String file = dlg.open();
            if (file != null) {
                try {
                    FileWriter writer = new FileWriter(file);
                    try {
                        TreeItem[] items = this.getView().getTreeItem();
                        int i = 0;
                        while (i < items.length) {
                            writer.append(items[i].getText()).append(System.getProperty("line.separator"));
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)shell, (String)OCLInterpreterMessages.OCLInterpreterView_exportResultError_title, (String)e.getLocalizedMessage());
                    }
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)shell, (String)OCLInterpreterMessages.OCLInterpreterView_exportResultError_title, (String)e.getLocalizedMessage());
                }
            }
        } else {
            MessageDialog.openWarning((Shell)shell, (String)OCLInterpreterMessages.OCLInterpreterView_exportResultWarn_title, (String)OCLInterpreterMessages.OCLInterpreterView_exportResultWarn_noExpr);
        }
    }
}

