/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.view.actions;

import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.ocl.requester.OCLRequesterPlugin;
import org.polarsys.capella.ocl.requester.internal.l10n.OCLInterpreterMessages;
import org.polarsys.capella.ocl.requester.view.actions.OCLInterpreterViewAction;

public class ExportOCLTextAction
extends OCLInterpreterViewAction {
    private final String tip = OCLInterpreterMessages.OCLInterpreterView_exportOCLTextAction_tip;

    public ExportOCLTextAction() {
        super(OCLInterpreterMessages.OCLInterpreterView_exportOCLTextAction_label, OCLRequesterPlugin.getImageDescriptor("icons/elcl16/oclexport.gif"));
    }

    public String getToolTipText() {
        return this.tip;
    }

    @Override
    public void run() {
        super.run();
        Shell shell = this.view.getPage().getShell();
        String oclExpression = null;
        try {
            oclExpression = this.view.getDocument().get(0, this.view.getDocument().getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        if (oclExpression != null) {
            FileDialog dlg = new FileDialog(shell, 8192);
            dlg.setFilterExtensions(new String[]{"*.ocl"});
            dlg.setText(OCLInterpreterMessages.OCLInterpreterView_exportOCLTextDlg_title);
            String file = dlg.open();
            if (file != null) {
                try {
                    FileWriter writer = new FileWriter(file);
                    try {
                        writer.append(oclExpression);
                    }
                    catch (IOException e) {
                        MessageDialog.openError((Shell)shell, (String)OCLInterpreterMessages.OCLInterpreterView_exportOCLTextError_title, (String)e.getLocalizedMessage());
                    }
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)shell, (String)OCLInterpreterMessages.OCLInterpreterView_exportOCLTextError_title, (String)e.getLocalizedMessage());
                }
            }
        } else {
            MessageDialog.openWarning((Shell)shell, (String)OCLInterpreterMessages.OCLInterpreterView_exportOCLTextWarn_title, (String)OCLInterpreterMessages.OCLInterpreterView_exportOCLTextWarn_noExpr);
        }
    }
}

