/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.model2ecore.internal.converters;

import java.util.Date;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datatype.util.DatatypeSwitch;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.model2ecore.internal.util.ModelHelper;

public class DataTypeConverter
extends DatatypeSwitch<EClassifier> {
    public EClassifier caseBooleanType(BooleanType booleanType) {
        EDataType result = null;
        if (Boolean.class.getSimpleName().equals(booleanType.getName())) {
            result = EcorePackage.Literals.EBOOLEAN;
        }
        return result;
    }

    public EClassifier caseDataType(DataType dataType) {
        EDataType result = EcoreFactory.eINSTANCE.createEDataType();
        String dataTypeName = ModelHelper.forceCharactersToEcoreNamingConventions(dataType.getName());
        result.setName(dataTypeName);
        result.setInstanceTypeName(dataTypeName);
        return result;
    }

    public EClassifier caseEnumeration(Enumeration capellaEnum) {
        EEnum ecoreEnum = EcoreFactory.eINSTANCE.createEEnum();
        ecoreEnum.setName(ModelHelper.forceCharactersToEcoreNamingConventions(capellaEnum.getName()));
        for (EnumerationLiteral capellaLiteral : capellaEnum.getOwnedLiterals()) {
            EEnumLiteral ecoreEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
            ecoreEnumLiteral.setName(ModelHelper.forceCharactersToEcoreNamingConventions(capellaLiteral.getName()));
            DataValue integerValue = capellaLiteral.getDomainValue();
            if (integerValue instanceof LiteralNumericValue) {
                ecoreEnumLiteral.setValue(ModelHelper.getValue((LiteralNumericValue)integerValue));
            }
            ecoreEnum.getELiterals().add((Object)ecoreEnumLiteral);
        }
        return ecoreEnum;
    }

    public EClassifier caseNumericType(NumericType numericType) {
        EDataType result = null;
        if (Byte.class.getSimpleName().equals(numericType.getName())) {
            result = EcorePackage.Literals.EBYTE;
        } else if (Double.class.getSimpleName().equals(numericType.getName())) {
            result = EcorePackage.Literals.EDOUBLE;
        } else if (Float.class.getSimpleName().equals(numericType.getName())) {
            result = EcorePackage.Literals.EFLOAT;
        } else if ("UnsignedInteger".equals(numericType.getName()) || Integer.class.getSimpleName().equals(numericType.getName())) {
            result = EcorePackage.Literals.EINT;
        } else if ("UnsignedLong".equals(numericType.getName()) || Long.class.getSimpleName().equals(numericType.getName())) {
            result = EcorePackage.Literals.ELONG;
        } else if ("UnsignedShort".equals(numericType.getName()) || Short.class.getSimpleName().equals(numericType.getName())) {
            result = EcorePackage.Literals.ESHORT;
        } else if ("UnsignedLongLong".equals(numericType.getName()) || "LongLong".equals(numericType.getName())) {
            result = EcorePackage.Literals.EBIG_INTEGER;
        } else if (Date.class.getSimpleName().equals(numericType.getName())) {
            result = EcorePackage.Literals.EDATE;
        } else {
            EList propertyValues = numericType.getOwnedPropertyValues();
            String dataTypeName = ModelHelper.forceCharactersToEcoreNamingConventions(numericType.getName());
            if (!propertyValues.isEmpty()) {
                result = EcoreFactory.eINSTANCE.createEClass();
                result.setName(dataTypeName);
                for (AbstractPropertyValue currentPropertyValue : propertyValues) {
                    EAttribute ecoreAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                    ((EClass)result).getEStructuralFeatures().add((Object)ecoreAttribute);
                    ecoreAttribute.setName(currentPropertyValue.getName());
                    ecoreAttribute.setEType(ModelHelper.getClassifier(currentPropertyValue));
                    ecoreAttribute.setLowerBound(1);
                    ecoreAttribute.setUpperBound(1);
                }
            } else {
                result = EcoreFactory.eINSTANCE.createEDataType();
                result.setName(dataTypeName);
                switch (numericType.getKind().getValue()) {
                    case 0: {
                        result.setInstanceClassName("int");
                        result.setInstanceTypeName("int");
                        break;
                    }
                    case 1: {
                        result.setInstanceClassName("float");
                        result.setInstanceTypeName("float");
                        break;
                    }
                }
            }
        }
        return result;
    }

    public EClassifier caseStringType(StringType stringType) {
        EDataType result = null;
        if (String.class.getSimpleName().equals(stringType.getName())) {
            result = EcorePackage.Literals.ESTRING;
        } else if ("Char".equals(stringType.getName())) {
            result = EcorePackage.Literals.ECHAR;
        }
        return result;
    }

    public EPackage getModelPackage() {
        return modelPackage;
    }
}

