/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.model2ecore.command;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.model2ecore.command.AbstractEcoreExporterCommand;
import org.polarsys.capella.model2ecore.internal.util.AbstractModelElementHandler;
import org.polarsys.capella.model2ecore.internal.util.ModelHelper;

public class InterfacePkgToEcoreExporter
extends AbstractEcoreExporterCommand {
    private static final String MODEL2ECORE_AGGREGATION = "Aggregation";
    private static final String MODEL2ECORE_DATA = "data";
    private static final String MODEL2ECORE_MESSAGE = "Message";
    private static final String MODEL2ECORE_NON_SECTIONED_MESSAGE = "nonsectionedmessage";
    private static final String MODEL2ECORE_MESSAGE_LENGTH = "messageLength";
    private static final String MODEL2ECORE_ONEWAY = "@oneway";
    private static final String MODEL2ECORE_STEREOTYPE = "@stereotype ";
    private static final String MODEL2ECORE_DATAFLOW = "dataflow";
    private static final String MODEL2ECORE_RPC = "rpc";

    public InterfacePkgToEcoreExporter() {
    }

    public InterfacePkgToEcoreExporter(Map<ModelElement, EClassifier> capellaToEcoreMappings, Map<AbstractDependenciesPkg, EPackage> packagesMappings) {
        super(capellaToEcoreMappings, packagesMappings);
    }

    protected void addModel2EcoreAggregationAnnotation(EStructuralFeature reference) {
        EAnnotation model2EcoreAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        reference.getEAnnotations().add((Object)model2EcoreAnnotation);
        model2EcoreAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
        EMap annotationEntries = model2EcoreAnnotation.getDetails();
        annotationEntries.put((Object)"documentation", (Object)"@stereotype Aggregation");
    }

    protected void addModel2EcoreAsynchronousAnnotation(EOperation eOperation, ExchangeItemAllocation exchangeItemAllocation, ExchangeItem exchangeItem) {
        String annotationContent;
        EAnnotation model2EcoreAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        EMap annotationEntries = model2EcoreAnnotation.getDetails();
        String summary = exchangeItem.getSummary();
        String string = annotationContent = summary != null ? summary : "";
        if (exchangeItemAllocation.getSendProtocol().equals((Object)CommunicationLinkProtocol.ASYNCHRONOUS)) {
            annotationContent = !annotationContent.isEmpty() ? String.valueOf(annotationContent) + '\n' + MODEL2ECORE_ONEWAY : MODEL2ECORE_ONEWAY;
        }
        if (!annotationContent.isEmpty()) {
            annotationEntries.put((Object)"documentation", (Object)annotationContent);
            eOperation.getEAnnotations().add((Object)model2EcoreAnnotation);
            model2EcoreAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
        }
    }

    protected void addModel2EcoreDataAnnotation(EReference reference) {
        EAnnotation model2EcoreAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        reference.getEAnnotations().add((Object)model2EcoreAnnotation);
        model2EcoreAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
        EMap annotationEntries = model2EcoreAnnotation.getDetails();
        annotationEntries.put((Object)"documentation", (Object)"@stereotype data");
    }

    protected void addModel2EcoreMessageLengthAnnotation(EAttribute attribute) {
        EAnnotation model2EcoreAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        attribute.getEAnnotations().add((Object)model2EcoreAnnotation);
        model2EcoreAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
        EMap annotationEntries = model2EcoreAnnotation.getDetails();
        annotationEntries.put((Object)"documentation", (Object)"@stereotype messageLength");
    }

    protected void addModel2EcoreNonSectionedMessageAnnotation(EClass message) {
        EAnnotation model2EcoreAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        message.getEAnnotations().add((Object)model2EcoreAnnotation);
        model2EcoreAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
        EMap annotationEntries = model2EcoreAnnotation.getDetails();
        annotationEntries.put((Object)"documentation", (Object)"@stereotype nonsectionedmessage");
    }

    protected void addModel2EcorePatternAnnotation(EClass ecoreInterface, ExchangeItem exchangeItem) {
        EList interfaceAnnotations = ecoreInterface.getEAnnotations();
        if (interfaceAnnotations.isEmpty()) {
            EAnnotation model2EcoreAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            interfaceAnnotations.add(model2EcoreAnnotation);
            model2EcoreAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            EMap annotationEntries = model2EcoreAnnotation.getDetails();
            String pattern = null;
            switch (exchangeItem.getExchangeMechanism().getValue()) {
                case 2: {
                    pattern = MODEL2ECORE_RPC;
                    break;
                }
                case 1: {
                    pattern = MODEL2ECORE_DATAFLOW;
                    break;
                }
                default: {
                    System.err.println("ExchangeMechanism not handled:" + exchangeItem.getName() + " mechanism:" + exchangeItem.getExchangeMechanism());
                }
            }
            annotationEntries.put((Object)"documentation", (Object)(MODEL2ECORE_STEREOTYPE + pattern));
        }
    }

    protected void createDataFlowContent(EClass ecoreDataFlow, ExchangeItem exchangeItem) {
        this.addModel2EcorePatternAnnotation(ecoreDataFlow, exchangeItem);
        EClass message = EcoreFactory.eINSTANCE.createEClass();
        message.setName(String.valueOf(exchangeItem.getName()) + MODEL2ECORE_MESSAGE);
        this.addModel2EcoreNonSectionedMessageAnnotation(message);
        ecoreDataFlow.getEPackage().getEClassifiers().add((Object)message);
        this.createMessageReference(ecoreDataFlow, message);
        this.createMessageContent(message, exchangeItem);
    }

    protected EOperation createEOperation(EClass relatedEcoreClass, ExchangeItem exchangeItem) {
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        eOperation.setName(ModelHelper.forceCharactersToEcoreNamingConventions(exchangeItem.getName()));
        relatedEcoreClass.getEOperations().add((Object)eOperation);
        for (ExchangeItemElement exchangeItemElement : exchangeItem.getOwnedElements()) {
            EClassifier ecoreType;
            EOperation ecoreElement = null;
            String name = null;
            ParameterDirection direction = exchangeItemElement.getDirection();
            if (ParameterDirection.RETURN.equals((Object)direction)) {
                ecoreElement = eOperation;
            } else {
                EParameter ecoreParameter = EcoreFactory.eINSTANCE.createEParameter();
                eOperation.getEParameters().add((Object)ecoreParameter);
                name = exchangeItemElement.getName();
                ecoreElement = ecoreParameter;
                String summary = exchangeItemElement.getSummary();
                if (summary != null && !summary.isEmpty()) {
                    EAnnotation model2EcoreAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    ecoreElement.getEAnnotations().add((Object)model2EcoreAnnotation);
                    model2EcoreAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
                    EMap annotationEntries = model2EcoreAnnotation.getDetails();
                    annotationEntries.put((Object)"documentation", (Object)summary);
                }
            }
            AbstractType capellaType = exchangeItemElement.getAbstractType();
            EClassifier eClassifier = ecoreType = capellaType != null ? this.getEcoreType(capellaType) : null;
            if (name != null) {
                ecoreElement.setName(ModelHelper.forceCharactersToEcoreNamingConventions(name));
            }
            if (ecoreType != null) {
                ecoreElement.setEType(ecoreType);
            } else {
                System.err.println("Ecore Type not found for " + eOperation.getName() + " parameter:" + name);
            }
            ecoreElement.setLowerBound(ModelHelper.getValue((LiteralNumericValue)exchangeItemElement.getOwnedMinCard()));
            ecoreElement.setUpperBound(ModelHelper.getValue((LiteralNumericValue)exchangeItemElement.getOwnedMaxCard()));
        }
        return eOperation;
    }

    protected void createMessageContent(EClass message, ExchangeItem exchangeItem) {
        EAttribute ecoreAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        this.addModel2EcoreMessageLengthAnnotation(ecoreAttribute);
        ecoreAttribute.setEType((EClassifier)EcorePackage.Literals.EINT);
        ecoreAttribute.setName(MODEL2ECORE_MESSAGE_LENGTH);
        ecoreAttribute.setUpperBound(1);
        ecoreAttribute.setLowerBound(1);
        message.getEStructuralFeatures().add((Object)ecoreAttribute);
        EList ownedElements = exchangeItem.getOwnedElements();
        for (ExchangeItemElement exchangeItemElement : ownedElements) {
            AbstractType abstractType = exchangeItemElement.getAbstractType();
            EReference contentRelation = EcoreFactory.eINSTANCE.createEReference();
            if (abstractType instanceof DataType) {
                contentRelation = EcoreFactory.eINSTANCE.createEAttribute();
            } else {
                contentRelation.setContainment(true);
            }
            this.addModel2EcoreAggregationAnnotation((EStructuralFeature)contentRelation);
            message.getEStructuralFeatures().add((Object)contentRelation);
            contentRelation.setEType(this.getEcoreType(abstractType));
            contentRelation.setUpperBound(ModelHelper.getValue((LiteralNumericValue)exchangeItemElement.getOwnedMaxCard()));
            contentRelation.setLowerBound(ModelHelper.getValue((LiteralNumericValue)exchangeItemElement.getOwnedMinCard()));
            contentRelation.setName(ModelHelper.forceCharactersToEcoreNamingConventions(exchangeItemElement.getName()));
        }
    }

    protected void createMessageReference(EClass ecoreDataFlow, EClass dataStructure) {
        EReference reference = EcoreFactory.eINSTANCE.createEReference();
        ecoreDataFlow.getEStructuralFeatures().add((Object)reference);
        reference.setEType((EClassifier)dataStructure);
        reference.setUpperBound(1);
        reference.setLowerBound(1);
        reference.setName(ModelHelper.forceCharactersToEcoreNamingConventions(MODEL2ECORE_DATA));
        reference.setContainment(true);
        this.addModel2EcoreDataAnnotation(reference);
    }

    @Override
    protected void exportPackage(AbstractDependenciesPkg capellaRootPackage, EPackage ecorePackage) {
        this.handlePackageContentWalk((InterfacePkg)capellaRootPackage, ecorePackage);
        this.handleInterfaces();
        this.handleDataFlow();
    }

    protected void handleDataFlow() {
        HashMap<ModelElement, EClassifier> capellaToEcoreMappings = new HashMap<ModelElement, EClassifier>(this.getCapellaToEcoreMappings());
        for (Map.Entry entry : capellaToEcoreMappings.entrySet()) {
            EObject key = (EObject)entry.getKey();
            if (!(key instanceof ExchangeItem)) continue;
            ExchangeItem exchangeItem = (ExchangeItem)key;
            EClass ecoreDataflow = (EClass)entry.getValue();
            this.createDataFlowContent(ecoreDataflow, exchangeItem);
        }
    }

    protected void handleExchangeItemAllocation(Interface capellaInterface, EClass relatedEcoreClass) {
        System.out.println();
        EList ownedGeneralizations = capellaInterface.getOwnedGeneralizations();
        for (Generalization generalization : ownedGeneralizations) {
            GeneralizableElement superInterface = generalization.getSuper();
            relatedEcoreClass.getESuperTypes().add((Object)((EClass)this.getEcoreType((AbstractType)superInterface)));
        }
        for (ExchangeItemAllocation currentExchangeItemAllocation : capellaInterface.getOwnedExchangeItemAllocations()) {
            ExchangeItem allocatedItem = currentExchangeItemAllocation.getAllocatedItem();
            if (!(allocatedItem instanceof ExchangeItem)) continue;
            ExchangeItem exchangeItem = allocatedItem;
            ExchangeMechanism exchangeMechanism = exchangeItem.getExchangeMechanism();
            this.addModel2EcorePatternAnnotation(relatedEcoreClass, exchangeItem);
            if (!ExchangeMechanism.OPERATION.equals((Object)exchangeMechanism)) continue;
            EOperation eOperation = this.createEOperation(relatedEcoreClass, exchangeItem);
            this.addModel2EcoreAsynchronousAnnotation(eOperation, currentExchangeItemAllocation, exchangeItem);
        }
    }

    protected void handleInterfaces() {
        HashMap<ModelElement, EClassifier> capellaToEcoreMappings = new HashMap<ModelElement, EClassifier>(this.getCapellaToEcoreMappings());
        for (Map.Entry entry : capellaToEcoreMappings.entrySet()) {
            EObject key = (EObject)entry.getKey();
            if (!(key instanceof Interface)) continue;
            Interface currentCapellaInterface = (Interface)key;
            this.handleExchangeItemAllocation(currentCapellaInterface, (EClass)entry.getValue());
        }
    }

    protected void handlePackageContentWalk(InterfacePkg capellaRootPackage, EPackage ecorePackage) {
        AbstractModelElementHandler handler = new AbstractModelElementHandler(){

            @Override
            public Couple<EClassifier, Boolean> handleElement(ModelElement element, EPackage parentPackage, AbstractEcoreExporterCommand exporter) {
                ExchangeItem exchangeItem;
                EClass classifier = null;
                boolean shouldPersistInResultingEcore = true;
                if (element instanceof Interface) {
                    ExchangeItem allocatedItem;
                    Interface interface_l = (Interface)element;
                    EList ownedExchangeItemAllocations = interface_l.getOwnedExchangeItemAllocations();
                    if (!ownedExchangeItemAllocations.isEmpty() && (allocatedItem = ((ExchangeItemAllocation)ownedExchangeItemAllocations.get(0)).getAllocatedItem()).getExchangeMechanism().equals((Object)ExchangeMechanism.OPERATION)) {
                        EClass ecoreInterface = EcoreFactory.eINSTANCE.createEClass();
                        ecoreInterface.setName(ModelHelper.forceCharactersToEcoreNamingConventions(((Interface)element).getName()));
                        ecoreInterface.setInterface(true);
                        ecoreInterface.setAbstract(true);
                        classifier = ecoreInterface;
                    }
                } else if (element instanceof InterfacePkg) {
                    InterfacePkg subCapellaPackage = (InterfacePkg)element;
                    EPackage subEcorePackage = InterfacePkgToEcoreExporter.this.createEPackage((AbstractDependenciesPkg)subCapellaPackage);
                    exporter.walkThroughPackageContent((AbstractDependenciesPkg)subCapellaPackage, subEcorePackage, this);
                    parentPackage.getESubpackages().add((Object)subEcorePackage);
                } else if (element instanceof ExchangeItem && (exchangeItem = (ExchangeItem)element).getExchangeMechanism().equals((Object)ExchangeMechanism.FLOW)) {
                    EClass ecoreDataFlow = EcoreFactory.eINSTANCE.createEClass();
                    ecoreDataFlow.setName(ModelHelper.forceCharactersToEcoreNamingConventions(exchangeItem.getName()));
                    classifier = ecoreDataFlow;
                }
                return new Couple(classifier, (Object)shouldPersistInResultingEcore);
            }
        };
        this.walkThroughPackageContent((AbstractDependenciesPkg)capellaRootPackage, ecorePackage, handler);
    }
}

