/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.FileID;

public class LibExtClassLoaderHelper {
    public static ClassLoader createLibExtClassLoader(List<File> jarsContainerOrJars, List<URL> otherJarsOrFolder, ClassLoader parentClassLoader) throws MalformedURLException {
        if (jarsContainerOrJars == null && otherJarsOrFolder == null) {
            return parentClassLoader;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (otherJarsOrFolder != null) {
            urls.addAll(otherJarsOrFolder);
        }
        if (jarsContainerOrJars != null) {
            for (File libExt : jarsContainerOrJars) {
                if (!libExt.isDirectory()) continue;
                for (File f : libExt.listFiles()) {
                    if (!FileID.isJavaArchive((String)f.getName())) continue;
                    URL url = f.toURI().toURL();
                    if (f.isFile()) {
                        url = new URL("jar:" + url.toString() + "!/");
                    }
                    urls.add(url);
                }
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parentClassLoader);
    }
}

