/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.component.LifeCycle;

public class ServerConnectorListener
implements LifeCycle.Listener {
    private Path _filePath;
    private String _sysPropertyName;

    public void lifeCycleStarted(LifeCycle event) {
        if (event instanceof ServerConnector) {
            ServerConnector serverConnector = (ServerConnector)event;
            if (this.getFilePath() != null) {
                try {
                    String line = String.valueOf(serverConnector.getLocalPort());
                    Files.writeString(this.getFilePath(), (CharSequence)line, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.getSysPropertyName() != null) {
                System.setProperty(this._sysPropertyName, String.valueOf(serverConnector.getLocalPort()));
            }
        }
    }

    public Path getFilePath() {
        return this._filePath;
    }

    public void setFilePath(Path filePath) {
        this._filePath = filePath;
    }

    public String getSysPropertyName() {
        return this._sysPropertyName;
    }

    public void setSysPropertyName(String sysPropertyName) {
        this._sysPropertyName = sysPropertyName;
    }
}

