/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.bre.Function_temp;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

public class BirtDuration
implements IScriptFunctionExecutor {
    private static final long serialVersionUID = 1L;
    private IScriptFunctionExecutor executor;
    private static final String PLUGIN_ID = "org.eclipse.birt.core.function";

    public BirtDuration(String functionName) throws BirtException {
        if ("year".equals(functionName)) {
            this.executor = new Function_Year();
        } else if ("month".equals(functionName)) {
            this.executor = new Function_Month();
        } else if ("day".equals(functionName)) {
            this.executor = new Function_Day();
        } else if ("hour".equals(functionName)) {
            this.executor = new Function_Hours();
        } else if ("minute".equals(functionName)) {
            this.executor = new Function_Minutes();
        } else if ("second".equals(functionName)) {
            this.executor = new Function_Seconds();
        } else if ("timeInMills".equals(functionName)) {
            this.executor = new Function_TimeInMills();
        } else if ("isLongerThan".equals(functionName)) {
            this.executor = new Function_Longer();
        } else if ("isShorterThan".equals(functionName)) {
            this.executor = new Function_Shorter();
        } else if ("getSign".equals(functionName)) {
            this.executor = new Function_GetSign();
        } else if ("multiply".equals(functionName)) {
            this.executor = new Function_Multiply();
        } else if ("negate".equals(functionName)) {
            this.executor = new Function_Negate();
        } else if ("subtract".equals(functionName)) {
            this.executor = new Function_Subtract();
        } else if ("add".equals(functionName)) {
            this.executor = new Function_Add();
        } else if ("addTo".equals(functionName)) {
            this.executor = new Function_AddTo();
        } else if ("compare".equals(functionName)) {
            this.executor = new Function_Compare();
        } else {
            throw new BirtException(PLUGIN_ID, null, (Object)(Messages.getString("invalid.function.name") + "BirtDuration." + functionName));
        }
    }

    public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
        return this.executor.execute(arguments, context);
    }

    private static class Function_Add
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Add() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.add(duration2).toString();
        }
    }

    private static class Function_AddTo
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddTo() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Date date;
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
                date = DataTypeUtil.toDate((Object)args[1]);
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            duration.addTo(date);
            return date;
        }
    }

    private static class Function_Compare
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Compare() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.compare(duration2);
        }
    }

    private static class Function_Day
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Day() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getDays();
        }
    }

    private static class Function_GetSign
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_GetSign() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration.getSign();
        }
    }

    private static class Function_Hours
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Hours() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getHours();
        }
    }

    private static class Function_Longer
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Longer() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.isLongerThan(duration2);
        }
    }

    private static class Function_Minutes
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Minutes() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getMinutes();
        }
    }

    private static class Function_Month
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Month() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getMonths();
        }
    }

    private static class Function_Multiply
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Multiply() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            int factor;
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
                factor = DataTypeUtil.toInteger((Object)args[1]);
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration.multiply(factor).toString();
        }
    }

    private static class Function_Negate
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Negate() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration.negate().toString();
        }
    }

    private static class Function_Seconds
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Seconds() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getSeconds();
        }
    }

    private static class Function_Shorter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Shorter() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.isShorterThan(duration2);
        }
    }

    private static class Function_Subtract
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Subtract() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration2;
            Duration duration1;
            try {
                duration1 = DatatypeFactory.newInstance().newDuration(args[0].toString());
                duration2 = DatatypeFactory.newInstance().newDuration(args[1].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", args));
            }
            return duration1.subtract(duration2).toString();
        }
    }

    private static class Function_TimeInMills
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_TimeInMills() {
            this.minParamCount = 2;
            this.maxParamCount = 2;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getTimeInMillis(DataTypeUtil.toDate((Object)args[1]));
        }
    }

    private static class Function_Year
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Year() {
            this.minParamCount = 1;
            this.maxParamCount = 1;
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(args[0].toString());
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(Messages.getFormattedString("error.BirtDuration.literal.invalidArgument", new Object[]{args[0].toString()}));
            }
            return duration.getYears();
        }
    }
}

