/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.basic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.IAnnotatable;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-Basic-CustomProperty-Key", checks={"Custom property keys have to be unique"})
public class AmBasicCustomPropertyKey
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getIAnnotatable();
    }

    public void validate(EObject object, List<ValidationDiagnostic> results) {
        if (object instanceof IAnnotatable) {
            IAnnotatable anno = (IAnnotatable)object;
            HashMap<String, Boolean> visitedKeys = new HashMap<String, Boolean>();
            for (Map.Entry entry : anno.getCustomProperties().entrySet()) {
                String key = (String)entry.getKey();
                if (visitedKeys.containsKey(key)) {
                    if (!Boolean.TRUE.equals(visitedKeys.get(key))) continue;
                    this.addIssue(results, (EObject)anno, (EStructuralFeature)ePackage.getIAnnotatable_CustomProperties(), "CustomProperty: duplicate key \"" + key + "\" ( in " + this.objectInfo((EObject)anno) + " )");
                    visitedKeys.put(key, false);
                    continue;
                }
                visitedKeys.put(key, true);
            }
        }
    }
}

