/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.shapes;

import java.util.Map;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.shapes.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FigureShape<T extends Shape>
implements Shape {
    private IFigure3D m_figure;
    private T m_shape;

    protected IFigure3D getFigure() {
        return this.m_figure;
    }

    protected T getShape() {
        return this.m_shape;
    }

    public FigureShape(IFigure3D i_figure, T i_shape) {
        if (i_figure == null) {
            throw new NullPointerException("i_figure must not be null");
        }
        if (i_shape == null) {
            throw new NullPointerException("i_shape must not be null");
        }
        this.m_figure = i_figure;
        this.m_shape = i_shape;
    }

    @Override
    public float getDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        return this.m_shape.getDistance(i_rayOrigin, i_rayDirection, i_context);
    }

    @Override
    public ParaxialBoundingBox getParaxialBoundingBox(ParaxialBoundingBox o_result) {
        return this.m_shape.getParaxialBoundingBox(o_result);
    }

    @Override
    public float getDistanceMeasure(RenderContext i_renderContext) {
        return this.m_shape.getDistanceMeasure(i_renderContext);
    }

    @Override
    public RenderFragment.RenderType getRenderType() {
        return this.m_shape.getRenderType();
    }

    public String toString() {
        return "FigureShape [m_figure=" + this.m_figure + ", m_shape=" + this.m_shape + "]";
    }
}

