/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class TreeImagePainter
extends ImagePainter {
    private Image collapsedImage;
    private Image expandedImage;
    private Image leafImage;

    public TreeImagePainter() {
        this(true);
    }

    public TreeImagePainter(boolean paintBg) {
        this(paintBg, GUIHelper.getImage("plus"), GUIHelper.getImage("minus"), GUIHelper.getImage("leaf"));
    }

    public TreeImagePainter(Image plusImage, Image minusImage, Image leafImage) {
        this(true, plusImage, minusImage, leafImage);
    }

    public TreeImagePainter(boolean paintBg, Image plusImage, Image minusImage, Image leafImage) {
        super(null, paintBg);
        this.collapsedImage = plusImage;
        this.expandedImage = minusImage;
        this.leafImage = leafImage;
    }

    public Image getPlusImage() {
        return this.collapsedImage;
    }

    public Image getMinusImage() {
        return this.expandedImage;
    }

    public Image getLeafImage() {
        return this.leafImage;
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        Image icon = null;
        if (this.isLeaf(cell)) {
            icon = this.leafImage;
        } else if (this.isCollapsed(cell)) {
            icon = this.collapsedImage;
        } else if (this.isExpanded(cell)) {
            icon = this.expandedImage;
        }
        return icon;
    }

    private boolean isLeaf(ILayerCell cell) {
        return cell.getConfigLabels().hasLabel("TREE_LEAF");
    }

    private boolean isCollapsed(ILayerCell cell) {
        return cell.getConfigLabels().hasLabel("TREE_COLLAPSED");
    }

    private boolean isExpanded(ILayerCell cell) {
        return cell.getConfigLabels().hasLabel("TREE_EXPANDED");
    }

    public void setExpandCollapseImages(Image collapsedImage, Image expandedImage, Image leafImage) {
        this.collapsedImage = collapsedImage;
        this.expandedImage = expandedImage;
        this.leafImage = leafImage;
    }
}

