/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.scoping;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.structuredtextcore.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.scoping.STCoreScopeProvider;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitializerExpression;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticMessageProvider;

public class STCoreLinkingDiagnosticMessageProvider
extends LinkingDiagnosticMessageProvider {
    public DiagnosticMessage getUnresolvedProxyMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        if (context.getReference() == STCorePackage.Literals.ST_VAR_DECLARATION__TYPE || context.getReference() == STCorePackage.Literals.ST_TYPE_DECLARATION__TYPE || STCoreScopeProvider.isAnyElementaryLiteral(context.getReference())) {
            return STCoreLinkingDiagnosticMessageProvider.createDataTypeDiagnosticMessage(context);
        }
        if (context.getReference() == STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE) {
            STFeatureExpression expression;
            INamedElement receiverType = STCoreLinkingDiagnosticMessageProvider.getReceiverType(context);
            EObject eObject = context.getContext();
            if (eObject instanceof STFeatureExpression && (expression = (STFeatureExpression)eObject).isCall()) {
                List<INamedElement> argumentTypes = expression.getParameters().stream().map(STCallArgument::getDeclaredResultType).toList();
                return STCoreLinkingDiagnosticMessageProvider.createCallableDiagnosticMessage(context, argumentTypes, receiverType);
            }
            return STCoreLinkingDiagnosticMessageProvider.createVariableDiagnosticMessage(context, receiverType);
        }
        if (context.getReference() == STCorePackage.Literals.ST_CALL_NAMED_INPUT_ARGUMENT__PARAMETER || context.getReference() == STCorePackage.Literals.ST_CALL_NAMED_OUTPUT_ARGUMENT__PARAMETER) {
            INamedElement feature = STCoreScopeProvider.getFeature(context.getContext());
            return STCoreLinkingDiagnosticMessageProvider.createParameterDiagnosticMessage(context, feature);
        }
        if (context.getReference() == STCorePackage.Literals.ST_FOR_STATEMENT__VARIABLE) {
            return STCoreLinkingDiagnosticMessageProvider.createVariableDiagnosticMessage(context, null);
        }
        if (context.getReference() == STCorePackage.Literals.ST_STRUCT_INIT_ELEMENT__VARIABLE) {
            StructuredType structType;
            STStructInitializerExpression structInitializerExpression;
            INamedElement iNamedElement;
            EObject container = context.getContext().eContainer();
            if (container instanceof STStructInitializerExpression && (iNamedElement = (structInitializerExpression = (STStructInitializerExpression)container).getResultType()) instanceof StructuredType && !(structType = (StructuredType)iNamedElement).eIsProxy()) {
                return STCoreLinkingDiagnosticMessageProvider.createVariableDiagnosticMessage(context, (INamedElement)structType);
            }
            return STCoreLinkingDiagnosticMessageProvider.createVariableDiagnosticMessage(context, null);
        }
        return super.getUnresolvedProxyMessage(context);
    }

    protected static INamedElement getReceiverType(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        STExpression receiver = STCoreScopeProvider.getReceiver(context.getContext());
        if (receiver != null && receiver != context.getContext()) {
            return receiver.getResultType();
        }
        return null;
    }

    protected static DiagnosticMessage createDataTypeDiagnosticMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        return new DiagnosticMessage(MessageFormat.format(Messages.STCoreLinkingDiagnosticMessageProvider_UndefinedDataType, context.getLinkText()), Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    protected static DiagnosticMessage createVariableDiagnosticMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, INamedElement type) {
        if (type != null && !type.eIsProxy()) {
            return new DiagnosticMessage(MessageFormat.format(Messages.STCoreLinkingDiagnosticMessageProvider_UndefinedVariableForType, context.getLinkText(), type.getQualifiedName()), Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
        }
        return new DiagnosticMessage(MessageFormat.format(Messages.STCoreLinkingDiagnosticMessageProvider_UndefinedVariable, context.getLinkText()), Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    protected static DiagnosticMessage createCallableDiagnosticMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, List<INamedElement> argumentTypes, INamedElement type) {
        String argumentTypesString = argumentTypes.stream().map(t -> t != null ? t.getName() : Messages.STCoreLinkingDiagnosticMessageProvider_UnknownType).collect(Collectors.joining(", "));
        if (type != null && !type.eIsProxy()) {
            return new DiagnosticMessage(MessageFormat.format(Messages.STCoreLinkingDiagnosticMessageProvider_UndefinedCallableForType, context.getLinkText(), argumentTypesString, type.getQualifiedName()), Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
        }
        return new DiagnosticMessage(MessageFormat.format(Messages.STCoreLinkingDiagnosticMessageProvider_UndefinedCallable, context.getLinkText(), argumentTypesString), Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    protected static DiagnosticMessage createParameterDiagnosticMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, INamedElement feature) {
        ICallable callable;
        if (feature instanceof ICallable && !(callable = (ICallable)feature).eIsProxy()) {
            return new DiagnosticMessage(MessageFormat.format(Messages.STCoreLinkingDiagnosticMessageProvider_UndefinedParameterForCallable, context.getLinkText(), callable.getQualifiedName()), Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
        }
        return new DiagnosticMessage(MessageFormat.format(Messages.STCoreLinkingDiagnosticMessageProvider_UndefinedParameter, context.getLinkText()), Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }
}

