/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.resource.FordiacTypeResource;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.STCoreChangeSerializer;
import org.eclipse.xtext.ide.refactoring.IResourceRelocationStrategy;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationChange;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationContext;
import org.eclipse.xtext.resource.FileExtensionProvider;

public class LibraryElementResourceRelocationStrategy
implements IResourceRelocationStrategy {
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public void applyChange(ResourceRelocationContext context) {
        if (!(context.getChangeSerializer() instanceof STCoreChangeSerializer)) {
            return;
        }
        context.getChanges().stream().filter(this::isRelevant).forEach(change -> this.applyChange(context, (ResourceRelocationChange)change));
    }

    protected void applyChange(ResourceRelocationContext context, ResourceRelocationChange change) {
        context.addModification(change, resource -> this.modifyResource((Resource)resource, change, context.getChangeType()));
    }

    protected void modifyResource(Resource resource, ResourceRelocationChange change, ResourceRelocationContext.ChangeType changeType) {
        Object object;
        FordiacTypeResource typeResource;
        if (resource instanceof FordiacTypeResource && !(typeResource = (FordiacTypeResource)resource).getContents().isEmpty() && (object = typeResource.getContents().getFirst()) instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)object;
            this.updateTypeName(libraryElement, change);
            if (changeType != ResourceRelocationContext.ChangeType.RENAME) {
                this.updatePackageName(libraryElement, change);
            }
        }
    }

    protected void updateTypeName(LibraryElement libraryElement, ResourceRelocationChange change) {
        String newName;
        String oldName = libraryElement.getName();
        if (!oldName.equals(newName = TypeEntry.getTypeNameFromFileName((String)change.getToURI().lastSegment()))) {
            libraryElement.setName(newName);
        }
    }

    protected void updatePackageName(LibraryElement libraryElement, ResourceRelocationChange change) {
        String newPackageName;
        String oldPackageName = PackageNameHelper.getPackageName((LibraryElement)libraryElement);
        if (!oldPackageName.equals(newPackageName = PackageNameHelper.getPackageNameFromURI((URI)change.getToURI()))) {
            PackageNameHelper.setPackageName((LibraryElement)libraryElement, (String)newPackageName);
        }
    }

    protected boolean isRelevant(ResourceRelocationChange change) {
        String fileExtension = change.getFromURI().fileExtension();
        return fileExtension != null && this.fileExtensionProvider.isValid(fileExtension.toLowerCase());
    }
}

