/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import java.util.Arrays;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public class IntRangeSet
extends IntSet {
    private int[] startPoints;
    private int[] endPoints;
    private int used = 0;
    private int _hashCode = -1;
    private int count = 0;

    public IntRangeSet() {
        this.startPoints = new int[4];
        this.endPoints = new int[4];
        this.used = 0;
        this.count = 0;
        this._hashCode = -1;
    }

    public IntRangeSet(IntRangeSet input) {
        this.startPoints = new int[input.used];
        this.endPoints = new int[input.used];
        this.used = input.used;
        System.arraycopy(input.startPoints, 0, this.startPoints, 0, this.used);
        System.arraycopy(input.endPoints, 0, this.endPoints, 0, this.used);
        this._hashCode = input._hashCode;
    }

    public IntRangeSet(int[] startPoints, int[] endPoints) {
        if (startPoints.length != endPoints.length) {
            throw new IllegalArgumentException("Array lengths differ");
        }
        this.startPoints = startPoints;
        this.endPoints = endPoints;
        this.used = startPoints.length;
        for (int i = 0; i < this.used; ++i) {
            this.count += endPoints[i] - startPoints[i] + 1;
        }
    }

    @Override
    public void clear() {
        this.startPoints = new int[4];
        this.endPoints = new int[4];
        this.used = 0;
        this._hashCode = -1;
    }

    @Override
    public IntSet copy() {
        IntRangeSet s2 = new IntRangeSet();
        s2.startPoints = new int[this.startPoints.length];
        System.arraycopy(this.startPoints, 0, s2.startPoints, 0, this.startPoints.length);
        s2.endPoints = new int[this.endPoints.length];
        System.arraycopy(this.endPoints, 0, s2.endPoints, 0, this.endPoints.length);
        s2.used = this.used;
        s2.count = this.count;
        return s2;
    }

    @Override
    public IntSet mutableCopy() {
        return this.copy();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(int value) {
        if (this.used == 0) {
            return false;
        }
        if (value > this.endPoints[this.used - 1]) {
            return false;
        }
        if (value < this.startPoints[0]) {
            return false;
        }
        int i = 0;
        int j = this.used;
        do {
            int mid;
            if (this.endPoints[mid = i + (j - i) / 2] < value) {
                i = Math.max(mid, i + 1);
                continue;
            }
            if (this.startPoints[mid] > value) {
                j = Math.min(mid, j - 1);
                continue;
            }
            return true;
        } while (i != j);
        return false;
    }

    @Override
    public boolean remove(int value) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean add(int value) {
        this._hashCode = -1;
        if (this.used == 0) {
            this.ensureCapacity(1);
            this.startPoints[this.used - 1] = value;
            this.endPoints[this.used - 1] = value;
            ++this.count;
            return true;
        }
        if (value > this.endPoints[this.used - 1]) {
            if (value == this.endPoints[this.used - 1] + 1) {
                int n = this.used - 1;
                this.endPoints[n] = this.endPoints[n] + 1;
            } else {
                this.ensureCapacity(this.used + 1);
                this.startPoints[this.used - 1] = value;
                this.endPoints[this.used - 1] = value;
            }
            ++this.count;
            return true;
        }
        if (value < this.startPoints[0]) {
            if (value == this.startPoints[0] - 1) {
                this.startPoints[0] = this.startPoints[0] - 1;
            } else {
                this.ensureCapacity(this.used + 1);
                System.arraycopy(this.startPoints, 0, this.startPoints, 1, this.used - 1);
                System.arraycopy(this.endPoints, 0, this.endPoints, 1, this.used - 1);
                this.startPoints[0] = value;
                this.endPoints[0] = value;
            }
            ++this.count;
            return true;
        }
        int i = 0;
        int j = this.used;
        do {
            int mid;
            if (this.endPoints[mid = i + (j - i) / 2] < value) {
                i = Math.max(mid, i + 1);
                continue;
            }
            if (this.startPoints[mid] > value) {
                j = Math.min(mid, j - 1);
                continue;
            }
            return false;
        } while (i != j);
        if (i > 0 && this.endPoints[i - 1] + 1 == value) {
            --i;
        } else if (i < this.used - 1 && this.startPoints[i + 1] - 1 == value) {
            ++i;
        }
        if (this.endPoints[i] + 1 == value) {
            if (value == this.startPoints[i + 1] - 1) {
                this.endPoints[i] = this.endPoints[i + 1];
                System.arraycopy(this.startPoints, i + 2, this.startPoints, i + 1, this.used - i - 2);
                System.arraycopy(this.endPoints, i + 2, this.endPoints, i + 1, this.used - i - 2);
                --this.used;
            } else {
                int n = i;
                this.endPoints[n] = this.endPoints[n] + 1;
            }
            ++this.count;
            return true;
        }
        if (this.startPoints[i] - 1 == value) {
            if (value == this.endPoints[i - 1] + 1) {
                this.endPoints[i - 1] = this.endPoints[i];
                System.arraycopy(this.startPoints, i + 1, this.startPoints, i, this.used - i - 1);
                System.arraycopy(this.endPoints, i + 1, this.endPoints, i, this.used - i - 1);
                --this.used;
            } else {
                int n = i;
                this.startPoints[n] = this.startPoints[n] - 1;
            }
            ++this.count;
            return true;
        }
        if (value > this.endPoints[i]) {
            ++i;
        }
        this.ensureCapacity(this.used + 1);
        try {
            System.arraycopy(this.startPoints, i, this.startPoints, i + 1, this.used - i - 1);
            System.arraycopy(this.endPoints, i, this.endPoints, i + 1, this.used - i - 1);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.startPoints[i] = value;
        this.endPoints[i] = value;
        ++this.count;
        return true;
    }

    private void ensureCapacity(int n) {
        if (this.startPoints.length < n) {
            int[] s2 = new int[this.startPoints.length * 2];
            int[] e = new int[this.startPoints.length * 2];
            System.arraycopy(this.startPoints, 0, s2, 0, this.used);
            System.arraycopy(this.endPoints, 0, e, 0, this.used);
            this.startPoints = s2;
            this.endPoints = e;
        }
        this.used = n;
    }

    @Override
    public IntIterator iterator() {
        return new IntRangeSetIterator(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.used * 8);
        for (int i = 0; i < this.used; ++i) {
            sb.append(this.startPoints[i] + "-" + this.endPoints[i] + ",");
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof IntSet) {
            if (other instanceof IntRangeSet) {
                return this.used == ((IntRangeSet)other).used && Arrays.equals(this.startPoints, ((IntRangeSet)other).startPoints) && Arrays.equals(this.endPoints, ((IntRangeSet)other).endPoints);
            }
            return this.containsAll((IntSet)other);
        }
        return false;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            int h2 = 1131055601;
            for (int i = 0; i < this.used; ++i) {
                h2 ^= this.startPoints[i] + (this.endPoints[i] << 3);
            }
            this._hashCode = h2;
        }
        return this._hashCode;
    }

    public void addRange(int low, int high) {
        if (low == high) {
            this.add(low);
            return;
        }
        this._hashCode = -1;
        if (this.used == 0) {
            this.ensureCapacity(1);
            this.startPoints[this.used - 1] = low;
            this.endPoints[this.used - 1] = high;
            this.count += high - low + 1;
        } else if (low > this.endPoints[this.used - 1]) {
            if (low == this.endPoints[this.used - 1] + 1) {
                this.endPoints[this.used - 1] = high;
            } else {
                this.ensureCapacity(this.used + 1);
                this.startPoints[this.used - 1] = low;
                this.endPoints[this.used - 1] = high;
            }
            this.count += high - low + 1;
        } else if (high < this.startPoints[0]) {
            this.ensureCapacity(this.used + 1);
            System.arraycopy(this.startPoints, 0, this.startPoints, 1, this.used - 1);
            System.arraycopy(this.endPoints, 0, this.endPoints, 1, this.used - 1);
            this.startPoints[0] = low;
            this.endPoints[0] = high;
        } else {
            int i;
            for (i = 1; i < this.used; ++i) {
                if (this.startPoints[i] <= high || this.endPoints[i - 1] >= low) continue;
                this.ensureCapacity(this.used + 1);
                System.arraycopy(this.startPoints, i, this.startPoints, i + 1, this.used - i - 1);
                System.arraycopy(this.endPoints, i, this.endPoints, i + 1, this.used - i - 1);
                this.startPoints[i] = low;
                this.endPoints[i] = high;
                return;
            }
            for (i = low; i <= high; ++i) {
                this.add(i);
            }
        }
    }

    public int[] getStartPoints() {
        return this.startPoints;
    }

    public int[] getEndPoints() {
        return this.endPoints;
    }

    public int getNumberOfRanges() {
        return this.used;
    }

    private static class IntRangeSetIterator
    implements IntIterator {
        private IntRangeSet intRangeSet;
        private int i = 0;
        private int current = 0;

        public IntRangeSetIterator(IntRangeSet intRangeSet) {
            this.intRangeSet = intRangeSet;
            this.i = -1;
            this.current = Integer.MIN_VALUE;
        }

        @Override
        public boolean hasNext() {
            if (this.i < 0) {
                return this.intRangeSet.count > 0;
            }
            return this.current < this.intRangeSet.endPoints[this.intRangeSet.used - 1];
        }

        @Override
        public int next() {
            if (this.i < 0) {
                this.i = 0;
                this.current = this.intRangeSet.startPoints[0];
                return this.current;
            }
            if (this.current == this.intRangeSet.endPoints[this.i]) {
                this.current = this.intRangeSet.startPoints[++this.i];
                return this.current;
            }
            return ++this.current;
        }
    }
}

