/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.io.IOException;
import java.util.Arrays;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.str.WhitespaceString;
import net.sf.saxon.z.IntIterator;

public class CompressedWhitespace
extends WhitespaceString {
    private static final char[] WHITE_CHARS = new char[]{'\t', '\n', '\r', ' '};
    private static final int[] CODES = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, -1, -1, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3};
    private final long value;

    public CompressedWhitespace(long compressedValue) {
        this.value = compressedValue;
    }

    public static UnicodeString compressWS(char[] in, int start, int len) {
        int runlength = 1;
        int outlength = 0;
        for (int i = 0; i < len; ++i) {
            char c = in[i];
            if (c <= ' ' && CODES[c] >= 0) {
                if (i == len - 1 || c != in[i + 1] || runlength == 63) {
                    runlength = 1;
                    if (++outlength <= 8) continue;
                    return StringTool.compress(in, start, len, false);
                }
                ++runlength;
                continue;
            }
            return StringTool.compress(in, start, len, false);
        }
        int ix = 0;
        runlength = 1;
        int[] out = new int[outlength];
        for (int i = 0; i < len; ++i) {
            char c = in[i];
            if (i == len - 1 || c != in[i + 1] || runlength == 63) {
                out[ix++] = CODES[c] << 6 | runlength;
                runlength = 1;
                continue;
            }
            ++runlength;
        }
        long value = 0L;
        for (int i = 0; i < outlength; ++i) {
            value = value << 8 | (long)out[i];
        }
        return new CompressedWhitespace(value <<= 8 * (8 - outlength));
    }

    @Override
    public UnicodeString uncompress() {
        return CompressedWhitespace.uncompress(this.value);
    }

    public static UnicodeString uncompress(long value) {
        byte b;
        byte[] bytes = new byte[1000];
        int offset = 0;
        for (int s2 = 56; s2 >= 0 && (b = (byte)(value >> s2 & 0xFFL)) != 0; s2 -= 8) {
            byte c = (byte)(WHITE_CHARS[b >> 6 & 3] & 0xFF);
            int len = b & 0x3F;
            for (int j = 0; j < len; ++j) {
                bytes[offset++] = c;
            }
        }
        return new Twine8(Arrays.copyOf(bytes, offset));
    }

    public long getCompressedValue() {
        return this.value;
    }

    @Override
    public long length() {
        return CompressedWhitespace.length(this.value);
    }

    @Override
    public int length32() {
        return CompressedWhitespace.length(this.value);
    }

    public static int length(long value) {
        int c;
        int count = 0;
        for (int s2 = 56; s2 >= 0 && (c = (int)(value >> s2 & 0x3FL)) != 0; s2 -= 8) {
            count += c;
        }
        return count;
    }

    @Override
    public int codePointAt(long index) {
        byte b;
        int count = 0;
        for (int s2 = 56; s2 >= 0 && (b = (byte)(this.value >> s2 & 0xFFL)) != 0; s2 -= 8) {
            if ((long)(count += b & 0x3F) <= index) continue;
            return WHITE_CHARS[b >> 6 & 3];
        }
        throw new IndexOutOfBoundsException(index + "");
    }

    @Override
    public IntIterator codePoints() {
        return this.uncompress().codePoints();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CompressedWhitespace) {
            return this.value == ((CompressedWhitespace)obj).value;
        }
        return this.uncompress().equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void write(UnicodeWriter writer) throws IOException {
        byte b;
        for (int s2 = 56; s2 >= 0 && (b = (byte)(this.value >> s2 & 0xFFL)) != 0; s2 -= 8) {
            char c = WHITE_CHARS[b >> 6 & 3];
            int len = b & 0x3F;
            writer.writeRepeatedAscii((byte)c, len);
        }
    }

    @Override
    public void writeEscape(boolean[] specialChars, UnicodeWriter writer) throws IOException {
        byte b;
        for (int s2 = 56; s2 >= 0 && (b = (byte)(this.value >> s2 & 0xFFL)) != 0; s2 -= 8) {
            char c = WHITE_CHARS[b >> 6 & 3];
            int len = b & 0x3F;
            if (specialChars[c]) {
                byte[] e = null;
                if (c == '\n') {
                    e = StringConstants.ESCAPE_NL;
                } else if (c == '\r') {
                    e = StringConstants.ESCAPE_CR;
                } else if (c == '\t') {
                    e = StringConstants.ESCAPE_TAB;
                }
                assert (e != null);
                for (int j = 0; j < len; ++j) {
                    writer.writeAscii(e);
                }
                continue;
            }
            writer.writeRepeatedAscii((byte)c, len);
        }
    }
}

