# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from azure.core.configuration import Configuration
from azure.core.pipeline import policies

from ..version import VERSION


class AzureFileStorageConfiguration(Configuration):
    """Configuration for AzureFileStorage
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param version: Specifies the version of the operation to use for this
     request.
    :type version: str
    :param url: The URL of the service account, share, directory or file that
     is the target of the desired operation.
    :type url: str
    :ivar file_range_write_from_url: Only update is supported: - Update:
     Writes the bytes downloaded from the source url into the specified range.
    :type file_range_write_from_url: str
    """

    def __init__(self, version, url, **kwargs):

        if version is None:
            raise ValueError("Parameter 'version' must not be None.")
        if url is None:
            raise ValueError("Parameter 'url' must not be None.")

        super(AzureFileStorageConfiguration, self).__init__(**kwargs)
        self._configure(**kwargs)

        self.user_agent_policy.add_user_agent('azsdk-python-azurefilestorage/{}'.format(VERSION))
        self.generate_client_request_id = True
        self.accept_language = None

        self.version = version
        self.url = url
        self.file_range_write_from_url = "update"

    def _configure(self, **kwargs):
        self.user_agent_policy = kwargs.get('user_agent_policy') or policies.UserAgentPolicy(**kwargs)
        self.headers_policy = kwargs.get('headers_policy') or policies.HeadersPolicy(**kwargs)
        self.proxy_policy = kwargs.get('proxy_policy') or policies.ProxyPolicy(**kwargs)
        self.logging_policy = kwargs.get('logging_policy') or policies.NetworkTraceLoggingPolicy(**kwargs)
        self.retry_policy = kwargs.get('retry_policy') or policies.AsyncRetryPolicy(**kwargs)
        self.custom_hook_policy = kwargs.get('custom_hook_policy') or policies.CustomHookPolicy(**kwargs)
        self.redirect_policy = kwargs.get('redirect_policy') or policies.AsyncRedirectPolicy(**kwargs)
