# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING

from msrest import Serializer

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Iterable, Optional, TypeVar
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_list_latest_request(
    workspace_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
    top = kwargs.pop('top', None)  # type: Optional[int]
    skip = kwargs.pop('skip', 0)  # type: Optional[int]
    maxpagesize = kwargs.pop('maxpagesize', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/workspaces/{workspaceName}/indexes")
    path_format_arguments = {
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if top is not None:
        _query_parameters['top'] = _SERIALIZER.query("top", top, 'int')
    if skip is not None:
        _query_parameters['skip'] = _SERIALIZER.query("skip", skip, 'int')
    if maxpagesize is not None:
        _query_parameters['maxpagesize'] = _SERIALIZER.query("maxpagesize", maxpagesize, 'int')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_get_latest_request(
    workspace_name,  # type: str
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/workspaces/{workspaceName}/indexes/{name}")
    path_format_arguments = {
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, 'str'),
        "name": _SERIALIZER.url("name", name, 'str', max_length=254, min_length=0, pattern=r'^[a-zA-Z0-9][a-zA-Z0-9-_]*$'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_get_next_version_request(
    workspace_name,  # type: str
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/workspaces/{workspaceName}/indexes/{name}:getNextVersion")
    path_format_arguments = {
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, 'str'),
        "name": _SERIALIZER.url("name", name, 'str', max_length=254, min_length=0, pattern=r'^[a-zA-Z0-9][a-zA-Z0-9-_]*$'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_list_request(
    workspace_name,  # type: str
    name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
    list_view_type = kwargs.pop('list_view_type', "ActiveOnly")  # type: str
    order_by = kwargs.pop('order_by', None)  # type: Optional[str]
    tags = kwargs.pop('tags', None)  # type: Optional[str]
    top = kwargs.pop('top', None)  # type: Optional[int]
    skip = kwargs.pop('skip', 0)  # type: Optional[int]
    maxpagesize = kwargs.pop('maxpagesize', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/workspaces/{workspaceName}/indexes/{name}/versions")
    path_format_arguments = {
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, 'str'),
        "name": _SERIALIZER.url("name", name, 'str', max_length=254, min_length=0, pattern=r'^[a-zA-Z0-9][a-zA-Z0-9-_]*$'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    _query_parameters['listViewType'] = _SERIALIZER.query("list_view_type", list_view_type, 'str')
    if order_by is not None:
        _query_parameters['orderBy'] = _SERIALIZER.query("order_by", order_by, 'str')
    if tags is not None:
        _query_parameters['tags'] = _SERIALIZER.query("tags", tags, 'str')
    if top is not None:
        _query_parameters['top'] = _SERIALIZER.query("top", top, 'int')
    if skip is not None:
        _query_parameters['skip'] = _SERIALIZER.query("skip", skip, 'int')
    if maxpagesize is not None:
        _query_parameters['maxpagesize'] = _SERIALIZER.query("maxpagesize", maxpagesize, 'int')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_get_request(
    workspace_name,  # type: str
    name,  # type: str
    version,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/workspaces/{workspaceName}/indexes/{name}/versions/{version}")
    path_format_arguments = {
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, 'str'),
        "name": _SERIALIZER.url("name", name, 'str', max_length=254, min_length=0, pattern=r'^[a-zA-Z0-9][a-zA-Z0-9-_]*$'),
        "version": _SERIALIZER.url("version", version, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_create_or_update_request(
    workspace_name,  # type: str
    name,  # type: str
    version,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/workspaces/{workspaceName}/indexes/{name}/versions/{version}")
    path_format_arguments = {
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, 'str'),
        "name": _SERIALIZER.url("name", name, 'str', max_length=254, min_length=0, pattern=r'^[a-zA-Z0-9][a-zA-Z0-9-_]*$'),
        "version": _SERIALIZER.url("version", version, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )

# fmt: on
class IndexesOperations(object):
    """IndexesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.machinelearningservices.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list_latest(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        workspace_name,  # type: str
        top=None,  # type: Optional[int]
        skip=0,  # type: Optional[int]
        maxpagesize=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PagedIndex"]
        """List the latest version of each index. Latest is defined by most recent created by date.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param top: The number of result items to return.
        :type top: int
        :param skip: The number of result items to skip.
        :type skip: int
        :param maxpagesize: The maximum number of result items per page.
        :type maxpagesize: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PagedIndex or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.machinelearningservices.models.PagedIndex]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PagedIndex"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_latest_request(
                    workspace_name=workspace_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    template_url=self.list_latest.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_latest_request(
                    workspace_name=workspace_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PagedIndex", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list_latest.metadata = {'url': "/workspaces/{workspaceName}/indexes"}  # type: ignore

    @distributed_trace
    def get_latest(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        workspace_name,  # type: str
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.Index"
        """Get latest version of the Index. Latest is defined by most recent created by date.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Index"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_get_latest_request(
            workspace_name=workspace_name,
            name=name,
            api_version=api_version,
            template_url=self.get_latest.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Index', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_latest.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}"}  # type: ignore


    @distributed_trace
    def get_next_version(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        workspace_name,  # type: str
        name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.VersionInfo"
        """Get next Index version as defined by the server. The server keeps track of all versions that
        are string-representations of integers. If one exists, the nextVersion will be a string
        representation of the highest integer value + 1. Otherwise, the nextVersion will default to
        '1'.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VersionInfo, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.VersionInfo
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.VersionInfo"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_get_next_version_request(
            workspace_name=workspace_name,
            name=name,
            api_version=api_version,
            template_url=self.get_next_version.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('VersionInfo', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_next_version.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}:getNextVersion"}  # type: ignore


    @distributed_trace
    def list(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        workspace_name,  # type: str
        name,  # type: str
        list_view_type="ActiveOnly",  # type: str
        order_by=None,  # type: Optional[str]
        tags=None,  # type: Optional[str]
        top=None,  # type: Optional[int]
        skip=0,  # type: Optional[int]
        maxpagesize=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PagedIndex"]
        """List the versions of an Index given the name.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :param list_view_type: View type for including/excluding (for example) archived entities.
        :type list_view_type: str
        :param order_by: Ordering of list: Please choose orderby value from ['createdAt',
         'lastModifiedAt'].
        :type order_by: str
        :param tags: Comma-separated list of tag names (and optionally values). Example:
         tag1,tag2=value2.
        :type tags: str
        :param top: The number of result items to return.
        :type top: int
        :param skip: The number of result items to skip.
        :type skip: int
        :param maxpagesize: The maximum number of result items per page.
        :type maxpagesize: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PagedIndex or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.machinelearningservices.models.PagedIndex]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PagedIndex"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_request(
                    workspace_name=workspace_name,
                    name=name,
                    api_version=api_version,
                    list_view_type=list_view_type,
                    order_by=order_by,
                    tags=tags,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_request(
                    workspace_name=workspace_name,
                    name=name,
                    api_version=api_version,
                    list_view_type=list_view_type,
                    order_by=order_by,
                    tags=tags,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PagedIndex", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}/versions"}  # type: ignore

    @distributed_trace
    def get(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        workspace_name,  # type: str
        name,  # type: str
        version,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.Index"
        """Get a specific version of an Index.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :param version: Version of the index.
        :type version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Index"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_get_request(
            workspace_name=workspace_name,
            name=name,
            version=version,
            api_version=api_version,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Index', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}/versions/{version}"}  # type: ignore


    @distributed_trace
    def create_or_update(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        workspace_name,  # type: str
        name,  # type: str
        version,  # type: str
        body,  # type: "_models.Index"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.Index"
        """Creates or updates a IndexVersion.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :param version: Version of the index.
        :type version: str
        :param body: Properties of an Index Version.
        :type body: ~azure.mgmt.machinelearningservices.models.Index
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Index"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'Index')

        request = build_create_or_update_request(
            workspace_name=workspace_name,
            name=name,
            version=version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.create_or_update.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('Index', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('Index', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}/versions/{version}"}  # type: ignore

