# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iotfirmwaredefense.aio import IoTFirmwareDefenseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIoTFirmwareDefenseMgmtUsageMetricsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IoTFirmwareDefenseMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_usage_metrics_get(self, resource_group):
        response = await self.client.usage_metrics.get(
            resource_group_name=resource_group.name,
            workspace_name="str",
            name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_usage_metrics_list_by_workspace(self, resource_group):
        response = self.client.usage_metrics.list_by_workspace(
            resource_group_name=resource_group.name,
            workspace_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
