# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AttackStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Strategies for attacks."""

    EASY = "easy"
    """Represents a default set of easy complexity attacks. Easy complexity attacks require less
    effort, such as translation of a prompt into some encoding, and does not require any Large
    Language Model to convert or orchestrate."""
    MODERATE = "moderate"
    """Represents a default set of moderate complexity attacks. Moderate complexity attacks require
    having access to resources such as another generative AI model."""
    DIFFICULT = "difficult"
    """Represents a default set of difficult complexity attacks. Difficult complexity attacks include
    attacks that require access to significant resources and effort to execute an attack such as
    knowledge of search-based algorithms in addition to a generative AI model."""
    ASCII_ART = "ascii_art"
    """Generates visual art using ASCII characters, often used for creative or obfuscation purposes."""
    ASCII_SMUGGLER = "ascii_smuggler"
    """Conceals data within ASCII characters, making it harder to detect."""
    ATBASH = "atbash"
    """Implements the Atbash cipher, a simple substitution cipher where each letter is mapped to its
    reverse."""
    BASE64 = "base64"
    """Encodes binary data into a text format using Base64, commonly used for data transmission."""
    BINARY = "binary"
    """Converts text into binary code, representing data in a series of 0s and 1s."""
    CAESAR = "caesar"
    """Applies the Caesar cipher, a substitution cipher that shifts characters by a fixed number of
    positions."""
    CHARACTER_SPACE = "character_space"
    """Alters text by adding spaces between characters, often used for obfuscation."""
    JAILBREAK = "jailbreak"
    """Injects specially crafted prompts to bypass AI safeguards, known as User Injected Prompt
    Attacks (UPIA)."""
    ANSII_ATTACK = "ansii_attack"
    """Utilizes ANSI escape sequences to manipulate text appearance and behavior."""
    CHARACTER_SWAP = "character_swap"
    """Swaps characters within text to create variations or obfuscate the original content."""
    SUFFIX_APPEND = "suffix_append"
    """Appends an adversarial suffix to the prompt."""
    STRING_JOIN = "string_join"
    """Joins multiple strings together, often used for concatenation or obfuscation."""
    UNICODE_CONFUSABLE = "unicode_confusable"
    """Uses Unicode characters that look similar to standard characters, creating visual confusion."""
    UNICODE_SUBSTITUTION = "unicode_substitution"
    """Substitutes standard characters with Unicode equivalents, often for obfuscation."""
    DIACRITIC = "diacritic"
    """Adds diacritical marks to characters, changing their appearance and sometimes their meaning."""
    FLIP = "flip"
    """Flips characters from front to back, creating a mirrored effect."""
    LEETSPEAK = "leetspeak"
    """Transforms text into Leetspeak, a form of encoding that replaces letters with similar-looking
    numbers or symbols."""
    ROT13 = "rot13"
    """Applies the ROT13 cipher, a simple substitution cipher that shifts characters by 13 positions."""
    MORSE = "morse"
    """Encodes text into Morse code, using dots and dashes to represent characters."""
    URL = "url"
    """Encodes text into URL format."""
    BASELINE = "baseline"
    """Represents the baseline direct adversarial probing, which is used by attack strategies as the
    attack objective."""


class ChatRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A description of the intended purpose of a message within a chat completions interaction."""

    SYSTEM = "system"
    """The role that instructs or sets the behavior of the assistant."""
    DEVELOPER = "developer"
    """The role that provides instructions to the model prioritized ahead of user messages."""
    USER = "user"
    """The role that provides input for chat completions."""
    ASSISTANT = "assistant"
    """The role that provides responses to system-instructed, user-prompted input."""
    TOOL = "tool"
    """The role that represents extension tool activity within a chat completions operation."""


class CompletionsFinishReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Representation of the manner in which a completions response concluded."""

    STOPPED = "stop"
    """Completions ended normally and reached its end of token generation."""
    TOKEN_LIMIT_REACHED = "length"
    """Completions exhausted available token limits before generation could complete."""
    CONTENT_FILTERED = "content_filter"
    """Completions generated a response that was identified as potentially sensitive per content
    moderation policies."""
    TOOL_CALLS = "tool_calls"
    """Completion ended with the model calling a provided tool for output."""


class ConnectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Type (or category) of the connection."""

    AZURE_OPEN_AI = "AzureOpenAI"
    """Azure OpenAI Service"""
    AZURE_BLOB_STORAGE = "AzureBlob"
    """Azure Blob Storage, with specified container"""
    AZURE_STORAGE_ACCOUNT = "AzureStorageAccount"
    """Azure Blob Storage, with container not specified (used by Agents)"""
    AZURE_AI_SEARCH = "CognitiveSearch"
    """Azure AI Search"""
    COSMOS_DB = "CosmosDB"
    """CosmosDB"""
    API_KEY = "ApiKey"
    """Generic connection that uses API Key authentication"""
    APPLICATION_CONFIGURATION = "AppConfig"
    """Application Configuration"""
    APPLICATION_INSIGHTS = "AppInsights"
    """Application Insights"""
    CUSTOM = "CustomKeys"
    """Custom Keys"""


class CredentialType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The credential type used by the connection."""

    API_KEY = "ApiKey"
    """API Key credential"""
    ENTRA_ID = "AAD"
    """Entra ID credential (formerly known as AAD)"""
    SAS = "SAS"
    """Shared Access Signature (SAS) credential"""
    CUSTOM = "CustomKeys"
    """Custom credential"""
    NONE = "None"
    """No credential"""


class DatasetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the type of data."""

    URI_FILE = "uri_file"
    """URI file."""
    URI_FOLDER = "uri_folder"
    """URI folder."""


class DayOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Days of the week for recurrence schedule."""

    SUNDAY = "Sunday"
    """Sunday."""
    MONDAY = "Monday"
    """Monday."""
    TUESDAY = "Tuesday"
    """Tuesday."""
    WEDNESDAY = "Wednesday"
    """Wednesday."""
    THURSDAY = "Thursday"
    """Thursday."""
    FRIDAY = "Friday"
    """Friday."""
    SATURDAY = "Saturday"
    """Saturday."""


class DeploymentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of DeploymentType."""

    MODEL_DEPLOYMENT = "ModelDeployment"
    """Model deployment"""


class EvaluationRuleActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the evaluation action."""

    CONTINUOUS_EVALUATION = "continuousEvaluation"
    """Continuous evaluation."""
    HUMAN_EVALUATION = "humanEvaluation"
    """Human evaluation."""


class EvaluationRuleEventType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the evaluation rule event."""

    RESPONSE_COMPLETED = "response.completed"
    """Response completed."""
    MANUAL = "manual"
    """Manual trigger."""


class EvaluationTargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allowed types of evaluation targets."""

    MODEL_RESPONSE_GENERATION = "modelResponseGeneration"
    """Evaluation target that uses a model for response generation."""


class EvaluationTaxonomyInputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the evaluation taxonomy input."""

    AGENT = "agent"
    """Agent"""
    POLICY = "policy"
    """Policy."""


class EvaluatorCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The category of the evaluator."""

    QUALITY = "quality"
    """Quality"""
    SAFETY = "safety"
    """Risk & Safety"""
    AGENTS = "agents"
    """Agents"""


class EvaluatorDefinitionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of evaluator definition."""

    PROMPT = "prompt"
    """Prompt-based definition"""
    CODE = "code"
    """Code-based definition"""
    PROMPT_AND_CODE = "prompt_and_code"
    """Prompt & Code Based definition"""
    SERVICE = "service"
    """Service-based evaluator"""
    OPENAI_GRADERS = "openai_graders"
    """OpenAI graders"""


class EvaluatorMetricDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The direction of the metric indicating whether a higher value is better, a lower value is
    better, or neutral.
    """

    INCREASE = "increase"
    """It indicates a higher value is better for this metric"""
    DECREASE = "decrease"
    """It indicates a lower value is better for this metric"""
    NEUTRAL = "neutral"
    """It indicates no preference for this metric direction"""


class EvaluatorMetricType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the evaluator."""

    ORDINAL = "ordinal"
    """Ordinal metric representing categories that can be ordered or ranked."""
    CONTINUOUS = "continuous"
    """Continuous metric representing values in a continuous range."""
    BOOLEAN = "boolean"
    """Boolean metric representing true/false values"""


class EvaluatorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the evaluator."""

    BUILT_IN = "builtin"
    """Built-in evaluator (Microsoft provided)"""
    CUSTOM = "custom"
    """Custom evaluator"""


class IndexType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of IndexType."""

    AZURE_SEARCH = "AzureSearch"
    """Azure search"""
    COSMOS_DB = "CosmosDBNoSqlVectorStore"
    """CosmosDB"""
    MANAGED_AZURE_SEARCH = "ManagedAzureSearch"
    """Managed Azure Search"""


class InsightType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The request of the insights."""

    EVALUATION_RUN_CLUSTER_INSIGHT = "EvaluationRunClusterInsight"
    """Insights on an Evaluation run result."""
    AGENT_CLUSTER_INSIGHT = "AgentClusterInsight"
    """Cluster Insight on an Agent."""
    EVALUATION_COMPARISON = "EvaluationComparison"
    """Evaluation Comparison."""


class ListViewType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List View Type Definition."""

    ACTIVE_ONLY = "ActiveOnly"
    """List only active items."""
    ARCHIVED_ONLY = "ArchivedOnly"
    """List only archived items."""
    ALL = "All"
    """List all items."""


class OperationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum describing allowed operation states."""

    NOT_STARTED = "NotStarted"
    """The operation has not started."""
    RUNNING = "Running"
    """The operation is in progress."""
    SUCCEEDED = "Succeeded"
    """The operation has completed successfully."""
    FAILED = "Failed"
    """The operation has failed."""
    CANCELED = "Canceled"
    """The operation has been canceled by the user."""


class PendingUploadType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of pending upload."""

    NONE = "None"
    """No pending upload."""
    BLOB_REFERENCE = "BlobReference"
    """Blob Reference is the only supported type."""
    TEMPORARY_BLOB_REFERENCE = "TemporaryBlobReference"
    """Temporary Blob Reference is the only supported type."""


class RecurrenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Recurrence type."""

    HOURLY = "Hourly"
    """Hourly recurrence pattern."""
    DAILY = "Daily"
    """Daily recurrence pattern."""
    WEEKLY = "Weekly"
    """Weekly recurrence pattern."""
    MONTHLY = "Monthly"
    """Monthly recurrence pattern."""


class ResultType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Evaluation result."""

    BENCHMARK = "Benchmark"
    """Benchmark result"""
    EVALUATION = "Evaluation"
    """Evaluations Result"""
    REDTEAM = "Redteam"
    """Red Team Result"""
    SIMULATION = "Simulation"
    """Simulation Result"""


class RiskCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Risk category for the attack objective."""

    HATE_UNFAIRNESS = "HateUnfairness"
    """Represents content related to hate or unfairness."""
    VIOLENCE = "Violence"
    """Represents content related to violence."""
    SEXUAL = "Sexual"
    """Represents content of a sexual nature."""
    SELF_HARM = "SelfHarm"
    """Represents content related to self-harm."""
    PROTECTED_MATERIAL = "ProtectedMaterial"
    """Represents content involving protected material."""
    CODE_VULNERABILITY = "CodeVulnerability"
    """Represents content related to code vulnerabilities."""
    UNGROUNDED_ATTRIBUTES = "UngroundedAttributes"
    """Represents content with ungrounded attributes."""


class SampleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of sample used in the analysis."""

    EVALUATION_RESULT_SAMPLE = "EvaluationResultSample"
    """A sample from the evaluation result."""


class ScheduleProvisioningStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Schedule provisioning status."""

    CREATING = "Creating"
    """Represents the creation status of the schedule."""
    UPDATING = "Updating"
    """Represents the updating status of the schedule."""
    DELETING = "Deleting"
    """Represents the deleting status of the schedule."""
    SUCCEEDED = "Succeeded"
    """Represents the succeeded status of the schedule."""
    FAILED = "Failed"
    """Represents the failed status of the schedule."""


class ScheduleTaskType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the task."""

    EVALUATION = "Evaluation"
    """Evaluation task."""
    INSIGHT = "Insight"
    """Insight task."""


class SimulationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Simulation type."""

    DEFAULT = "Default"
    """Default simulation type."""
    CUSTOM_PERSONA = "CustomPersona"
    """Custom persona simulation type."""
    HARM_TURN_GENERATOR = "HarmTurnGenerator"
    """Harm turn generator simulation type."""


class TargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target type."""

    AZURE_AI_AGENT = "AzureAIAgent"
    """Azure AI Agent Target"""


class TreatmentEffectType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Treatment Effect Type."""

    TOO_FEW_SAMPLES = "TooFewSamples"
    """Not enough samples to determine treatment effect."""
    INCONCLUSIVE = "Inconclusive"
    """No significant difference between treatment and baseline."""
    CHANGED = "Changed"
    """Indicates the metric changed with statistical significance, but the direction is neutral."""
    IMPROVED = "Improved"
    """Indicates the treatment significantly improved the metric compared to baseline."""
    DEGRADED = "Degraded"
    """Indicates the treatment significantly degraded the metric compared to baseline."""


class TriggerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the trigger."""

    CRON = "Cron"
    """Cron based trigger."""
    RECURRENCE = "Recurrence"
    """Recurrence based trigger."""
    ONE_TIME = "OneTime"
    """One-time trigger."""
