# -*- bash -*-

fail () { echo >&2 "$us: error: $*"; exit 16; }
x () { echo >&2 "+ $*"; "$@"; }

parse-args-settings () {
    s_bpd=../bpd
    : ${DGIT_DRS_DGIT:=dgit}

    while [ $# != 0 ]; do
	case "$1" in
	    --*) fail "unknown option" ;;
	    *=*)
		k="${1%%=*}"
		v="${1#*=}"
		case "$k" in
		    *[^0-9a-z_]*) fail "bad syntax for setting" ;;
		    *)
			eval "s_$k=\$v"
			;;
		esac
		shift
		;;
	    *) fail "non-option arguments must all be settings K=V" ;;
	esac
    done
}

run-dgit () {
    x $DGIT_DRS_DGIT --build-products-dir="$s_bpd" -p"$s_p" "$@" >&2
}
report () {
    printf "%s\n" "$*"
    printf >&2 "# %s\n" "$*"
}
tempfail () {
    report "$*"
    exit 75
}
