; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvfhmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvfhmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvfhmin,+experimental-xrivosvizip -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZIP,ZIP-RV32
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvfhmin,+experimental-xrivosvizip -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZIP,ZIP-RV64

define <4 x i32> @zipeven_v4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: zipeven_v4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v0, 10
; CHECK-NEXT:    vslideup.vi v8, v9, 1, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v4i32:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v10, v8, v9
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  ret <4 x i32> %c
}

define <4 x i32> @zipeven_v4i32_swapped(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: zipeven_v4i32_swapped:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v0, 10
; CHECK-NEXT:    vslideup.vi v9, v8, 1, v0.t
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v4i32_swapped:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v10, v9, v8
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 4, i32 0, i32 6, i32 2>
  ret <4 x i32> %c
}

define <4 x i64> @zipeven_v4i64(<4 x i64> %a, <4 x i64> %b) {
; CHECK-LABEL: zipeven_v4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v0, 10
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vslideup.vi v8, v10, 1, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v4i64:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v12, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  ret <4 x i64> %c
}

define <4 x half> @zipeven_v4f16(<4 x half> %a, <4 x half> %b) {
; CHECK-LABEL: zipeven_v4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v0, 10
; CHECK-NEXT:    vslideup.vi v8, v9, 1, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v4f16:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v10, v8, v9
; ZIP-NEXT:    vmv1r.v v8, v10
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x half> %a, <4 x half> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  ret <4 x half> %c
}

define <4 x float> @zipeven_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: zipeven_v4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v0, 10
; CHECK-NEXT:    vslideup.vi v8, v9, 1, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v4f32:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v10, v8, v9
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x float> %a, <4 x float> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  ret <4 x float> %c
}

define <4 x double> @zipeven_v4f64(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: zipeven_v4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v0, 10
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vslideup.vi v8, v10, 1, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v4f64:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v12, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  ret <4 x double> %c
}


define <4 x i32> @zipodd_v4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: zipodd_v4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v0, 5
; CHECK-NEXT:    vslidedown.vi v9, v8, 1, v0.t
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipodd_v4i32:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZIP-NEXT:    ri.vzipodd.vv v10, v8, v9
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  ret <4 x i32> %c
}

define <4 x i32> @zipodd_v4i32_swapped(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: zipodd_v4i32_swapped:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v0, 5
; CHECK-NEXT:    vslidedown.vi v8, v9, 1, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipodd_v4i32_swapped:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZIP-NEXT:    ri.vzipodd.vv v10, v9, v8
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 5, i32 1, i32 7, i32 3>
  ret <4 x i32> %c
}

; This is the zipeven pattern with a poison second operand.  That happens
; to also be described as an identity shuffle, so this is testing that we
; don't emit the zipeven instruction.
define <4 x i32> @zipeven_v4i32_single(<4 x i32> %a) {
; CHECK-LABEL: zipeven_v4i32_single:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v4i32_single:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> poison, <4 x i32> <i32 0, i32 poison, i32 2, i32 poison>
  ret <4 x i32> %c
}

; This is the zipodd pattern with a poison second operand.  That happens
; to also be described as a single slide, so this is testing that we
; don't emit the zipodd instruction.
define <4 x i32> @zipodd_v4i32_single(<4 x i32> %a) {
; CHECK-LABEL: zipodd_v4i32_single:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 1
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipodd_v4i32_single:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZIP-NEXT:    vslidedown.vi v8, v8, 1
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> poison, <4 x i32> <i32 1, i32 poison, i32 3, i32 poison>
  ret <4 x i32> %c
}

define <4 x i32> @zipodd_v4i32_both(<4 x i32> %a) {
; CHECK-LABEL: zipodd_v4i32_both:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v0, 5
; CHECK-NEXT:    vslidedown.vi v8, v8, 1, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipodd_v4i32_both:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZIP-NEXT:    ri.vzipodd.vv v9, v8, v8
; ZIP-NEXT:    vmv.v.v v8, v9
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> poison, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  ret <4 x i32> %c
}

define <4 x i32> @zipeven_v4i32_both(<4 x i32> %a) {
; CHECK-LABEL: zipeven_v4i32_both:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v0, 10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vslideup.vi v9, v8, 1, v0.t
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v4i32_both:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v9, v8, v8
; ZIP-NEXT:    vmv.v.v v8, v9
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> poison, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  ret <4 x i32> %c
}

define <4 x i32> @zipeven_v4i32_partial(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: zipeven_v4i32_partial:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 2, e32, m1, tu, ma
; CHECK-NEXT:    vslideup.vi v8, v9, 1
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v4i32_partial:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 2, e32, m1, tu, ma
; ZIP-NEXT:    vslideup.vi v8, v9, 1
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 poison>
  ret <4 x i32> %c
}

define <4 x i32> @zipodd_v4i32_partial(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: zipodd_v4i32_partial:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmv.v.i v0, 5
; CHECK-NEXT:    vslidedown.vi v9, v8, 1, v0.t
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipodd_v4i32_partial:
; ZIP:       # %bb.0: # %entry
; ZIP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; ZIP-NEXT:    ri.vzipodd.vv v10, v8, v9
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    ret
entry:
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 1, i32 5, i32 3, i32 poison>
  ret <4 x i32> %c
}

define <8 x i32> @zipeven_v8i32(<8 x i32> %v1, <8 x i32> %v2) {
; CHECK-LABEL: zipeven_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 170
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmv.s.x v0, a0
; CHECK-NEXT:    vslideup.vi v8, v10, 1, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v8i32:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v12, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    ret
  %out = shufflevector <8 x i32> %v1, <8 x i32> %v2, <8 x i32> <i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14>
  ret <8 x i32> %out
}

define <8 x i32> @zipodd_v8i32(<8 x i32> %v1, <8 x i32> %v2) {
; CHECK-LABEL: zipodd_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmv.s.x v0, a0
; CHECK-NEXT:    vslidedown.vi v10, v8, 1, v0.t
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipodd_v8i32:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; ZIP-NEXT:    ri.vzipodd.vv v12, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    ret
  %out = shufflevector <8 x i32> %v1, <8 x i32> %v2, <8 x i32> <i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15>
  ret <8 x i32> %out
}

define <16 x i64> @zipeven_v16i64(<16 x i64> %v1, <16 x i64> %v2) {
; CHECK-LABEL: zipeven_v16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 11
; CHECK-NEXT:    addi a0, a0, -1366
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vmv.s.x v0, a0
; CHECK-NEXT:    vslideup.vi v8, v16, 1, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v16i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v24, v8, v16
; ZIP-NEXT:    vmv.v.v v8, v24
; ZIP-NEXT:    ret
  %out = shufflevector <16 x i64> %v1, <16 x i64> %v2, <16 x i32> <i32 0, i32 16, i32 2, i32 18, i32 4, i32 20, i32 6, i32 22, i32 8, i32 24, i32 10, i32 26, i32 12, i32 28, i32 14, i32 30>
  ret <16 x i64> %out
}

define <16 x i64> @zipodd_v16i64(<16 x i64> %v1, <16 x i64> %v2) {
; CHECK-LABEL: zipodd_v16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vmv.s.x v0, a0
; CHECK-NEXT:    vslidedown.vi v16, v8, 1, v0.t
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipodd_v16i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; ZIP-NEXT:    ri.vzipodd.vv v24, v8, v16
; ZIP-NEXT:    vmv.v.v v8, v24
; ZIP-NEXT:    ret
  %out = shufflevector <16 x i64> %v1, <16 x i64> %v2, <16 x i32> <i32 1, i32 17, i32 3, i32 19, i32 5, i32 21, i32 7, i32 23, i32 9, i32 25, i32 11, i32 27, i32 13, i32 29, i32 15, i32 31>
  ret <16 x i64> %out
}

define <8 x i32> @zipeven_v8i32_as_v4i64(<8 x i32> %v1, <8 x i32> %v2) {
; CHECK-LABEL: zipeven_v8i32_as_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 204
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmv.s.x v0, a0
; CHECK-NEXT:    vslideup.vi v8, v10, 2, v0.t
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipeven_v8i32_as_v4i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; ZIP-NEXT:    ri.vzipeven.vv v12, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    ret
  %out = shufflevector <8 x i32> %v1, <8 x i32> %v2, <8 x i32> <i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 12, i32 13>
  ret <8 x i32> %out
}

define <8 x i32> @zipodd_v8i32_as_v4i64(<8 x i32> %v1, <8 x i32> %v2) {
; CHECK-LABEL: zipodd_v8i32_as_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmv.s.x v0, a0
; CHECK-NEXT:    vslidedown.vi v10, v8, 2, v0.t
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
;
; ZIP-LABEL: zipodd_v8i32_as_v4i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; ZIP-NEXT:    ri.vzipodd.vv v12, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    ret
  %out = shufflevector <8 x i32> %v1, <8 x i32> %v2, <8 x i32> <i32 2, i32 3, i32 10, i32 11, i32 6, i32 7, i32 14, i32 15>
  ret <8 x i32> %out
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32: {{.*}}
; RV64: {{.*}}
; ZIP-RV32: {{.*}}
; ZIP-RV64: {{.*}}
