; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvfh,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvfh,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvfhmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvfhmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s

define void @masked_store_v1bf16(<1 x bfloat> %val, ptr %a, <1 x i1> %mask) {
; CHECK-LABEL: masked_store_v1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v1bf16.p0(<1 x bfloat> %val, ptr %a, i32 8, <1 x i1> %mask)
  ret void
}

define void @masked_store_v1f16(<1 x half> %val, ptr %a, <1 x i1> %mask) {
; CHECK-LABEL: masked_store_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v1f16.p0(<1 x half> %val, ptr %a, i32 8, <1 x i1> %mask)
  ret void
}

define void @masked_store_v1f32(<1 x float> %val, ptr %a, <1 x i1> %mask) {
; CHECK-LABEL: masked_store_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v1f32.p0(<1 x float> %val, ptr %a, i32 8, <1 x i1> %mask)
  ret void
}

define void @masked_store_v1f64(<1 x double> %val, ptr %a, <1 x i1> %mask) {
; CHECK-LABEL: masked_store_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v1f64.p0(<1 x double> %val, ptr %a, i32 8, <1 x i1> %mask)
  ret void
}

define void @masked_store_v2bf16(<2 x bfloat> %val, ptr %a, <2 x i1> %mask) {
; CHECK-LABEL: masked_store_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v2bf16.p0(<2 x bfloat> %val, ptr %a, i32 8, <2 x i1> %mask)
  ret void
}

define void @masked_store_v2f16(<2 x half> %val, ptr %a, <2 x i1> %mask) {
; CHECK-LABEL: masked_store_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v2f16.p0(<2 x half> %val, ptr %a, i32 8, <2 x i1> %mask)
  ret void
}

define void @masked_store_v2f32(<2 x float> %val, ptr %a, <2 x i1> %mask) {
; CHECK-LABEL: masked_store_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v2f32.p0(<2 x float> %val, ptr %a, i32 8, <2 x i1> %mask)
  ret void
}

define void @masked_store_v2f64(<2 x double> %val, ptr %a, <2 x i1> %mask) {
; CHECK-LABEL: masked_store_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v2f64.p0(<2 x double> %val, ptr %a, i32 8, <2 x i1> %mask)
  ret void
}

define void @masked_store_v4bf16(<4 x bfloat> %val, ptr %a, <4 x i1> %mask) {
; CHECK-LABEL: masked_store_v4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v4bf16.p0(<4 x bfloat> %val, ptr %a, i32 8, <4 x i1> %mask)
  ret void
}

define void @masked_store_v4f16(<4 x half> %val, ptr %a, <4 x i1> %mask) {
; CHECK-LABEL: masked_store_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v4f16.p0(<4 x half> %val, ptr %a, i32 8, <4 x i1> %mask)
  ret void
}

define void @masked_store_v4f32(<4 x float> %val, ptr %a, <4 x i1> %mask) {
; CHECK-LABEL: masked_store_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v4f32.p0(<4 x float> %val, ptr %a, i32 8, <4 x i1> %mask)
  ret void
}

define void @masked_store_v4f64(<4 x double> %val, ptr %a, <4 x i1> %mask) {
; CHECK-LABEL: masked_store_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v4f64.p0(<4 x double> %val, ptr %a, i32 8, <4 x i1> %mask)
  ret void
}

define void @masked_store_v8bf16(<8 x bfloat> %val, ptr %a, <8 x i1> %mask) {
; CHECK-LABEL: masked_store_v8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v8bf16.p0(<8 x bfloat> %val, ptr %a, i32 8, <8 x i1> %mask)
  ret void
}

define void @masked_store_v8f16(<8 x half> %val, ptr %a, <8 x i1> %mask) {
; CHECK-LABEL: masked_store_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v8f16.p0(<8 x half> %val, ptr %a, i32 8, <8 x i1> %mask)
  ret void
}

define void @masked_store_v8f32(<8 x float> %val, ptr %a, <8 x i1> %mask) {
; CHECK-LABEL: masked_store_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v8f32.p0(<8 x float> %val, ptr %a, i32 8, <8 x i1> %mask)
  ret void
}

define void @masked_store_v8f64(<8 x double> %val, ptr %a, <8 x i1> %mask) {
; CHECK-LABEL: masked_store_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v8f64.p0(<8 x double> %val, ptr %a, i32 8, <8 x i1> %mask)
  ret void
}

define void @masked_store_v16bf16(<16 x bfloat> %val, ptr %a, <16 x i1> %mask) {
; CHECK-LABEL: masked_store_v16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v16bf16.p0(<16 x bfloat> %val, ptr %a, i32 8, <16 x i1> %mask)
  ret void
}

define void @masked_store_v16f16(<16 x half> %val, ptr %a, <16 x i1> %mask) {
; CHECK-LABEL: masked_store_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v16f16.p0(<16 x half> %val, ptr %a, i32 8, <16 x i1> %mask)
  ret void
}

define void @masked_store_v16f32(<16 x float> %val, ptr %a, <16 x i1> %mask) {
; CHECK-LABEL: masked_store_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v16f32.p0(<16 x float> %val, ptr %a, i32 8, <16 x i1> %mask)
  ret void
}

define void @masked_store_v16f64(<16 x double> %val, ptr %a, <16 x i1> %mask) {
; CHECK-LABEL: masked_store_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v16f64.p0(<16 x double> %val, ptr %a, i32 8, <16 x i1> %mask)
  ret void
}

define void @masked_store_v32bf16(<32 x bfloat> %val, ptr %a, <32 x i1> %mask) {
; CHECK-LABEL: masked_store_v32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v32bf16.p0(<32 x bfloat> %val, ptr %a, i32 8, <32 x i1> %mask)
  ret void
}

define void @masked_store_v32f16(<32 x half> %val, ptr %a, <32 x i1> %mask) {
; CHECK-LABEL: masked_store_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v32f16.p0(<32 x half> %val, ptr %a, i32 8, <32 x i1> %mask)
  ret void
}

define void @masked_store_v32f32(<32 x float> %val, ptr %a, <32 x i1> %mask) {
; CHECK-LABEL: masked_store_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v32f32.p0(<32 x float> %val, ptr %a, i32 8, <32 x i1> %mask)
  ret void
}

define void @masked_store_v32f64(<32 x double> %val, ptr %a, <32 x i1> %mask) {
; CHECK-LABEL: masked_store_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v8, (a0), v0.t
; CHECK-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vi v0, v0, 2
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v16, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v32f64.p0(<32 x double> %val, ptr %a, i32 8, <32 x i1> %mask)
  ret void
}

define void @masked_store_v64bf16(<64 x bfloat> %val, ptr %a, <64 x i1> %mask) {
; CHECK-LABEL: masked_store_v64bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v64bf16.p0(<64 x bfloat> %val, ptr %a, i32 8, <64 x i1> %mask)
  ret void
}

define void @masked_store_v64f16(<64 x half> %val, ptr %a, <64 x i1> %mask) {
; CHECK-LABEL: masked_store_v64f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v64f16.p0(<64 x half> %val, ptr %a, i32 8, <64 x i1> %mask)
  ret void
}

define void @masked_store_v64f32(<64 x float> %val, ptr %a, <64 x i1> %mask) {
; CHECK-LABEL: masked_store_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vi v0, v0, 4
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vse32.v v16, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v64f32.p0(<64 x float> %val, ptr %a, i32 8, <64 x i1> %mask)
  ret void
}

define void @masked_store_v128bf16(<128 x bfloat> %val, ptr %a, <128 x i1> %mask) {
; CHECK-LABEL: masked_store_v128bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    vsetivli zero, 8, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v0, v0, 8
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v16, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v128bf16.p0(<128 x bfloat> %val, ptr %a, i32 8, <128 x i1> %mask)
  ret void
}

define void @masked_store_v128f16(<128 x half> %val, ptr %a, <128 x i1> %mask) {
; CHECK-LABEL: masked_store_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v8, (a0), v0.t
; CHECK-NEXT:    vsetivli zero, 8, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v0, v0, 8
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vse16.v v16, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v128f16.p0(<128 x half> %val, ptr %a, i32 8, <128 x i1> %mask)
  ret void
}

define void @masked_store_v7f32(<7 x float> %val, ptr %a, <7 x i1> %mask) {
; CHECK-LABEL: masked_store_v7f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 7, e32, m2, ta, ma
; CHECK-NEXT:    vse32.v v8, (a0), v0.t
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v7f32.p0(<7 x float> %val, ptr %a, i32 8, <7 x i1> %mask)
  ret void
}
