; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL

;
; vXi64
;

define i1 @test_v2i64(ptr %ptr) nounwind {
; SSE2-LABEL: test_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd (%rdi), %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v2i64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    setb %al
; AVX-NEXT:    retq
  %vload = load <2 x i64>, ptr %ptr
  %v0 = extractelement <2 x i64> %vload, i32 0
  %v1 = extractelement <2 x i64> %vload, i32 1
  %vreduce = and i64 %v0, %v1
  %vcheck = icmp eq i64 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v4i64(ptr %ptr) nounwind {
; SSE2-LABEL: test_v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    pand 16(%rdi), %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v4i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    pand 16(%rdi), %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %vload = load <4 x i64>, ptr %ptr
  %v0 = extractelement <4 x i64> %vload, i32 0
  %v1 = extractelement <4 x i64> %vload, i32 1
  %v2 = extractelement <4 x i64> %vload, i32 2
  %v3 = extractelement <4 x i64> %vload, i32 3
  %vreduce01 = and i64 %v0, %v1
  %vreduce23 = and i64 %v2, %v3
  %vreduce = and i64 %vreduce01, %vreduce23
  %vcheck = icmp eq i64 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v8i64(ptr %ptr) nounwind {
; SSE2-LABEL: test_v8i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    movdqa 16(%rdi), %xmm1
; SSE2-NEXT:    pand 48(%rdi), %xmm1
; SSE2-NEXT:    pand 32(%rdi), %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    movdqa 16(%rdi), %xmm1
; SSE41-NEXT:    pand 48(%rdi), %xmm1
; SSE41-NEXT:    pand 32(%rdi), %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vandps 32(%rdi), %ymm0, %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpand 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd {{.*#+}} zmm0 = -1
; AVX512-NEXT:    vpcmpneqd (%rdi), %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %vload = load <8 x i64>, ptr %ptr
  %v0 = extractelement <8 x i64> %vload, i32 0
  %v1 = extractelement <8 x i64> %vload, i32 1
  %v2 = extractelement <8 x i64> %vload, i32 2
  %v3 = extractelement <8 x i64> %vload, i32 3
  %v4 = extractelement <8 x i64> %vload, i32 4
  %v5 = extractelement <8 x i64> %vload, i32 5
  %v6 = extractelement <8 x i64> %vload, i32 6
  %v7 = extractelement <8 x i64> %vload, i32 7
  %vreduce01 = and i64 %v0, %v1
  %vreduce23 = and i64 %v2, %v3
  %vreduce45 = and i64 %v4, %v5
  %vreduce67 = and i64 %v6, %v7
  %vreduce0123 = and i64 %vreduce01, %vreduce23
  %vreduce4567 = and i64 %vreduce45, %vreduce67
  %vreduce = and i64 %vreduce0123, %vreduce4567
  %vcheck = icmp eq i64 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v16i64(ptr %ptr) nounwind {
; SSE2-LABEL: test_v16i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    movdqa 16(%rdi), %xmm1
; SSE2-NEXT:    movdqa 32(%rdi), %xmm2
; SSE2-NEXT:    movdqa 48(%rdi), %xmm3
; SSE2-NEXT:    pand 112(%rdi), %xmm3
; SSE2-NEXT:    pand 80(%rdi), %xmm1
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    pand 96(%rdi), %xmm2
; SSE2-NEXT:    pand 64(%rdi), %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    movdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movdqa 48(%rdi), %xmm3
; SSE41-NEXT:    pand 112(%rdi), %xmm3
; SSE41-NEXT:    pand 80(%rdi), %xmm1
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand 96(%rdi), %xmm2
; SSE41-NEXT:    pand 64(%rdi), %xmm0
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX1-NEXT:    vandps 96(%rdi), %ymm1, %ymm1
; AVX1-NEXT:    vandps 64(%rdi), %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-NEXT:    vpand 96(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    vpand 64(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vpandq 64(%rdi), %zmm0, %zmm0
; AVX512-NEXT:    vpternlogd {{.*#+}} zmm1 = -1
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %vload = load <16 x i64>, ptr %ptr
  %v0  = extractelement <16 x i64> %vload, i32 0
  %v1  = extractelement <16 x i64> %vload, i32 1
  %v2  = extractelement <16 x i64> %vload, i32 2
  %v3  = extractelement <16 x i64> %vload, i32 3
  %v4  = extractelement <16 x i64> %vload, i32 4
  %v5  = extractelement <16 x i64> %vload, i32 5
  %v6  = extractelement <16 x i64> %vload, i32 6
  %v7  = extractelement <16 x i64> %vload, i32 7
  %v8  = extractelement <16 x i64> %vload, i32 8
  %v9  = extractelement <16 x i64> %vload, i32 9
  %v10 = extractelement <16 x i64> %vload, i32 10
  %v11 = extractelement <16 x i64> %vload, i32 11
  %v12 = extractelement <16 x i64> %vload, i32 12
  %v13 = extractelement <16 x i64> %vload, i32 13
  %v14 = extractelement <16 x i64> %vload, i32 14
  %v15 = extractelement <16 x i64> %vload, i32 15
  %vreduce01 = and i64 %v0, %v1
  %vreduce23 = and i64 %v2, %v3
  %vreduce45 = and i64 %v4, %v5
  %vreduce67 = and i64 %v6, %v7
  %vreduce89 = and i64 %v8, %v9
  %vreduce1011 = and i64 %v10, %v11
  %vreduce1213 = and i64 %v12, %v13
  %vreduce1415 = and i64 %v14, %v15
  %vreduce0123 = and i64 %vreduce01, %vreduce23
  %vreduce4567 = and i64 %vreduce45, %vreduce67
  %vreduce891011 = and i64 %vreduce89, %vreduce1011
  %vreduce12131415 = and i64 %vreduce1213, %vreduce1415
  %vreduce01234567 = and i64 %vreduce0123, %vreduce4567
  %vreduce89101112131415 = and i64 %vreduce891011, %vreduce12131415
  %vreduce = and i64 %vreduce01234567, %vreduce89101112131415
  %vcheck = icmp eq i64 %vreduce, -1
  ret i1 %vcheck
}

;
; vXi32
;

define i1 @test_v2i32(ptr %ptr) nounwind {
; SSE-LABEL: test_v2i32:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpq $-1, (%rdi)
; SSE-NEXT:    sete %al
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v2i32:
; AVX:       # %bb.0:
; AVX-NEXT:    cmpq $-1, (%rdi)
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %vload = load <2 x i32>, ptr %ptr
  %v0 = extractelement <2 x i32> %vload, i32 0
  %v1 = extractelement <2 x i32> %vload, i32 1
  %vreduce = and i32 %v0, %v1
  %vcheck = icmp eq i32 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v4i32(ptr %ptr) nounwind {
; SSE2-LABEL: test_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd (%rdi), %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    setb %al
; AVX-NEXT:    retq
  %vload = load <4 x i32>, ptr %ptr
  %v0 = extractelement <4 x i32> %vload, i32 0
  %v1 = extractelement <4 x i32> %vload, i32 1
  %v2 = extractelement <4 x i32> %vload, i32 2
  %v3 = extractelement <4 x i32> %vload, i32 3
  %vreduce01 = and i32 %v0, %v1
  %vreduce23 = and i32 %v2, %v3
  %vreduce = and i32 %vreduce01, %vreduce23
  %vcheck = icmp eq i32 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v8i32(ptr %ptr) nounwind {
; SSE2-LABEL: test_v8i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    pand 16(%rdi), %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    pand 16(%rdi), %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %vload = load <8 x i32>, ptr %ptr
  %v0 = extractelement <8 x i32> %vload, i32 0
  %v1 = extractelement <8 x i32> %vload, i32 1
  %v2 = extractelement <8 x i32> %vload, i32 2
  %v3 = extractelement <8 x i32> %vload, i32 3
  %v4 = extractelement <8 x i32> %vload, i32 4
  %v5 = extractelement <8 x i32> %vload, i32 5
  %v6 = extractelement <8 x i32> %vload, i32 6
  %v7 = extractelement <8 x i32> %vload, i32 7
  %vreduce01 = and i32 %v0, %v1
  %vreduce23 = and i32 %v2, %v3
  %vreduce45 = and i32 %v4, %v5
  %vreduce67 = and i32 %v6, %v7
  %vreduce0123 = and i32 %vreduce01, %vreduce23
  %vreduce4567 = and i32 %vreduce45, %vreduce67
  %vreduce = and i32 %vreduce0123, %vreduce4567
  %vcheck = icmp eq i32 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v16i32(ptr %ptr) nounwind {
; SSE2-LABEL: test_v16i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    movdqa 16(%rdi), %xmm1
; SSE2-NEXT:    pand 48(%rdi), %xmm1
; SSE2-NEXT:    pand 32(%rdi), %xmm0
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    movdqa 16(%rdi), %xmm1
; SSE41-NEXT:    pand 48(%rdi), %xmm1
; SSE41-NEXT:    pand 32(%rdi), %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vandps 32(%rdi), %ymm0, %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpand 32(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd {{.*#+}} zmm0 = -1
; AVX512-NEXT:    vpcmpneqd (%rdi), %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %vload = load <16 x i32>, ptr %ptr
  %v0  = extractelement <16 x i32> %vload, i32 0
  %v1  = extractelement <16 x i32> %vload, i32 1
  %v2  = extractelement <16 x i32> %vload, i32 2
  %v3  = extractelement <16 x i32> %vload, i32 3
  %v4  = extractelement <16 x i32> %vload, i32 4
  %v5  = extractelement <16 x i32> %vload, i32 5
  %v6  = extractelement <16 x i32> %vload, i32 6
  %v7  = extractelement <16 x i32> %vload, i32 7
  %v8  = extractelement <16 x i32> %vload, i32 8
  %v9  = extractelement <16 x i32> %vload, i32 9
  %v10 = extractelement <16 x i32> %vload, i32 10
  %v11 = extractelement <16 x i32> %vload, i32 11
  %v12 = extractelement <16 x i32> %vload, i32 12
  %v13 = extractelement <16 x i32> %vload, i32 13
  %v14 = extractelement <16 x i32> %vload, i32 14
  %v15 = extractelement <16 x i32> %vload, i32 15
  %vreduce01 = and i32 %v0, %v1
  %vreduce23 = and i32 %v2, %v3
  %vreduce45 = and i32 %v4, %v5
  %vreduce67 = and i32 %v6, %v7
  %vreduce89 = and i32 %v8, %v9
  %vreduce1011 = and i32 %v10, %v11
  %vreduce1213 = and i32 %v12, %v13
  %vreduce1415 = and i32 %v14, %v15
  %vreduce0123 = and i32 %vreduce01, %vreduce23
  %vreduce4567 = and i32 %vreduce45, %vreduce67
  %vreduce891011 = and i32 %vreduce89, %vreduce1011
  %vreduce12131415 = and i32 %vreduce1213, %vreduce1415
  %vreduce01234567 = and i32 %vreduce0123, %vreduce4567
  %vreduce89101112131415 = and i32 %vreduce891011, %vreduce12131415
  %vreduce = and i32 %vreduce01234567, %vreduce89101112131415
  %vcheck = icmp eq i32 %vreduce, -1
  ret i1 %vcheck
}

;
; vXi16
;

define i1 @test_v2i16(ptr %ptr) nounwind {
; SSE-LABEL: test_v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpl $-1, (%rdi)
; SSE-NEXT:    sete %al
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v2i16:
; AVX:       # %bb.0:
; AVX-NEXT:    cmpl $-1, (%rdi)
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %vload = load <2 x i16>, ptr %ptr
  %v0 = extractelement <2 x i16> %vload, i32 0
  %v1 = extractelement <2 x i16> %vload, i32 1
  %vreduce = and i16 %v0, %v1
  %vcheck = icmp eq i16 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v4i16(ptr %ptr) nounwind {
; SSE-LABEL: test_v4i16:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpq $-1, (%rdi)
; SSE-NEXT:    sete %al
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v4i16:
; AVX:       # %bb.0:
; AVX-NEXT:    cmpq $-1, (%rdi)
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %vload = load <4 x i16>, ptr %ptr
  %v0 = extractelement <4 x i16> %vload, i32 0
  %v1 = extractelement <4 x i16> %vload, i32 1
  %v2 = extractelement <4 x i16> %vload, i32 2
  %v3 = extractelement <4 x i16> %vload, i32 3
  %vreduce01 = and i16 %v0, %v1
  %vreduce23 = and i16 %v2, %v3
  %vreduce = and i16 %vreduce01, %vreduce23
  %vcheck = icmp eq i16 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v8i16(ptr %ptr) nounwind {
; SSE2-LABEL: test_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb (%rdi), %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    setb %al
; AVX-NEXT:    retq
  %vload = load <8 x i16>, ptr %ptr
  %v0 = extractelement <8 x i16> %vload, i32 0
  %v1 = extractelement <8 x i16> %vload, i32 1
  %v2 = extractelement <8 x i16> %vload, i32 2
  %v3 = extractelement <8 x i16> %vload, i32 3
  %v4 = extractelement <8 x i16> %vload, i32 4
  %v5 = extractelement <8 x i16> %vload, i32 5
  %v6 = extractelement <8 x i16> %vload, i32 6
  %v7 = extractelement <8 x i16> %vload, i32 7
  %vreduce01 = and i16 %v0, %v1
  %vreduce23 = and i16 %v2, %v3
  %vreduce45 = and i16 %v4, %v5
  %vreduce67 = and i16 %v6, %v7
  %vreduce0123 = and i16 %vreduce01, %vreduce23
  %vreduce4567 = and i16 %vreduce45, %vreduce67
  %vreduce = and i16 %vreduce0123, %vreduce4567
  %vcheck = icmp eq i16 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v16i16(ptr %ptr) nounwind {
; SSE2-LABEL: test_v16i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa (%rdi), %xmm0
; SSE2-NEXT:    pand 16(%rdi), %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    pand 16(%rdi), %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %vload = load <16 x i16>, ptr %ptr
  %v0  = extractelement <16 x i16> %vload, i32 0
  %v1  = extractelement <16 x i16> %vload, i32 1
  %v2  = extractelement <16 x i16> %vload, i32 2
  %v3  = extractelement <16 x i16> %vload, i32 3
  %v4  = extractelement <16 x i16> %vload, i32 4
  %v5  = extractelement <16 x i16> %vload, i32 5
  %v6  = extractelement <16 x i16> %vload, i32 6
  %v7  = extractelement <16 x i16> %vload, i32 7
  %v8  = extractelement <16 x i16> %vload, i32 8
  %v9  = extractelement <16 x i16> %vload, i32 9
  %v10 = extractelement <16 x i16> %vload, i32 10
  %v11 = extractelement <16 x i16> %vload, i32 11
  %v12 = extractelement <16 x i16> %vload, i32 12
  %v13 = extractelement <16 x i16> %vload, i32 13
  %v14 = extractelement <16 x i16> %vload, i32 14
  %v15 = extractelement <16 x i16> %vload, i32 15
  %vreduce01 = and i16 %v0, %v1
  %vreduce23 = and i16 %v2, %v3
  %vreduce45 = and i16 %v4, %v5
  %vreduce67 = and i16 %v6, %v7
  %vreduce89 = and i16 %v8, %v9
  %vreduce1011 = and i16 %v10, %v11
  %vreduce1213 = and i16 %v12, %v13
  %vreduce1415 = and i16 %v14, %v15
  %vreduce0123 = and i16 %vreduce01, %vreduce23
  %vreduce4567 = and i16 %vreduce45, %vreduce67
  %vreduce891011 = and i16 %vreduce89, %vreduce1011
  %vreduce12131415 = and i16 %vreduce1213, %vreduce1415
  %vreduce01234567 = and i16 %vreduce0123, %vreduce4567
  %vreduce89101112131415 = and i16 %vreduce891011, %vreduce12131415
  %vreduce = and i16 %vreduce01234567, %vreduce89101112131415
  %vcheck = icmp eq i16 %vreduce, -1
  ret i1 %vcheck
}

;
; vXi8
;

define i1 @test_v2i8(ptr %ptr) nounwind {
; SSE-LABEL: test_v2i8:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpw $-1, (%rdi)
; SSE-NEXT:    sete %al
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v2i8:
; AVX:       # %bb.0:
; AVX-NEXT:    cmpw $-1, (%rdi)
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %vload = load <2 x i8>, ptr %ptr
  %v0 = extractelement <2 x i8> %vload, i32 0
  %v1 = extractelement <2 x i8> %vload, i32 1
  %vreduce = and i8 %v0, %v1
  %vcheck = icmp eq i8 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v4i8(ptr %ptr) nounwind {
; SSE-LABEL: test_v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpl $-1, (%rdi)
; SSE-NEXT:    sete %al
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v4i8:
; AVX:       # %bb.0:
; AVX-NEXT:    cmpl $-1, (%rdi)
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %vload = load <4 x i8>, ptr %ptr
  %v0 = extractelement <4 x i8> %vload, i32 0
  %v1 = extractelement <4 x i8> %vload, i32 1
  %v2 = extractelement <4 x i8> %vload, i32 2
  %v3 = extractelement <4 x i8> %vload, i32 3
  %vreduce01 = and i8 %v0, %v1
  %vreduce23 = and i8 %v2, %v3
  %vreduce = and i8 %vreduce01, %vreduce23
  %vcheck = icmp eq i8 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v8i8(ptr %ptr) nounwind {
; SSE-LABEL: test_v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    cmpq $-1, (%rdi)
; SSE-NEXT:    sete %al
; SSE-NEXT:    retq
;
; AVX-LABEL: test_v8i8:
; AVX:       # %bb.0:
; AVX-NEXT:    cmpq $-1, (%rdi)
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %vload = load <8 x i8>, ptr %ptr
  %v0 = extractelement <8 x i8> %vload, i32 0
  %v1 = extractelement <8 x i8> %vload, i32 1
  %v2 = extractelement <8 x i8> %vload, i32 2
  %v3 = extractelement <8 x i8> %vload, i32 3
  %v4 = extractelement <8 x i8> %vload, i32 4
  %v5 = extractelement <8 x i8> %vload, i32 5
  %v6 = extractelement <8 x i8> %vload, i32 6
  %v7 = extractelement <8 x i8> %vload, i32 7
  %vreduce01 = and i8 %v0, %v1
  %vreduce23 = and i8 %v2, %v3
  %vreduce45 = and i8 %v4, %v5
  %vreduce67 = and i8 %v6, %v7
  %vreduce0123 = and i8 %vreduce01, %vreduce23
  %vreduce4567 = and i8 %vreduce45, %vreduce67
  %vreduce = and i8 %vreduce0123, %vreduce4567
  %vcheck = icmp eq i8 %vreduce, -1
  ret i1 %vcheck
}

define i1 @test_v16i8(ptr %ptr) nounwind {
; SSE2-LABEL: test_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqb (%rdi), %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa (%rdi), %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    setb %al
; AVX-NEXT:    retq
  %vload = load <16 x i8>, ptr %ptr
  %v0  = extractelement <16 x i8> %vload, i32 0
  %v1  = extractelement <16 x i8> %vload, i32 1
  %v2  = extractelement <16 x i8> %vload, i32 2
  %v3  = extractelement <16 x i8> %vload, i32 3
  %v4  = extractelement <16 x i8> %vload, i32 4
  %v5  = extractelement <16 x i8> %vload, i32 5
  %v6  = extractelement <16 x i8> %vload, i32 6
  %v7  = extractelement <16 x i8> %vload, i32 7
  %v8  = extractelement <16 x i8> %vload, i32 8
  %v9  = extractelement <16 x i8> %vload, i32 9
  %v10 = extractelement <16 x i8> %vload, i32 10
  %v11 = extractelement <16 x i8> %vload, i32 11
  %v12 = extractelement <16 x i8> %vload, i32 12
  %v13 = extractelement <16 x i8> %vload, i32 13
  %v14 = extractelement <16 x i8> %vload, i32 14
  %v15 = extractelement <16 x i8> %vload, i32 15
  %vreduce01 = and i8 %v0, %v1
  %vreduce23 = and i8 %v2, %v3
  %vreduce45 = and i8 %v4, %v5
  %vreduce67 = and i8 %v6, %v7
  %vreduce89 = and i8 %v8, %v9
  %vreduce1011 = and i8 %v10, %v11
  %vreduce1213 = and i8 %v12, %v13
  %vreduce1415 = and i8 %v14, %v15
  %vreduce0123 = and i8 %vreduce01, %vreduce23
  %vreduce4567 = and i8 %vreduce45, %vreduce67
  %vreduce891011 = and i8 %vreduce89, %vreduce1011
  %vreduce12131415 = and i8 %vreduce1213, %vreduce1415
  %vreduce01234567 = and i8 %vreduce0123, %vreduce4567
  %vreduce89101112131415 = and i8 %vreduce891011, %vreduce12131415
  %vreduce = and i8 %vreduce01234567, %vreduce89101112131415
  %vcheck = icmp eq i8 %vreduce, -1
  ret i1 %vcheck
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX1OR2: {{.*}}
; AVX512BW: {{.*}}
; AVX512F: {{.*}}
; AVX512VL: {{.*}}
