; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+d,+zfh,+zvfh,+zfbfmin,+zvfbfmin,+v \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH,RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+d,+zfh,+zvfh,+zfbfmin,+zvfbfmin,+v \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH,RV64
; RUN: llc -mtriple=riscv32 -mattr=+m,+d,+zfh,+zvfhmin,+zfbfmin,+zvfbfmin,+v \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN,ZVFHMIN32
; RUN: llc -mtriple=riscv64 -mattr=+m,+d,+zfh,+zvfhmin,+zfbfmin,+zvfbfmin,+v \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN,ZVFHMIN64

; FIXME: The scalar/vector operations ('fv' tests) should swap operands and
; condition codes accordingly in order to generate a 'vf' instruction.

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_oeq_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_oeq_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_oeq_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_oeq_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_oeq_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_ogt_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ogt_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ogt_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_ogt_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_ogt_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_oge_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_oge_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_oge_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_oge_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_oge_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_olt_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_olt_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_olt_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_olt_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_olt_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_ole_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ole_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ole_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_ole_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_ole_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_one_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v16, v12
; CHECK-NEXT:    vmflt.vv v9, v12, v16
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_one_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v12, fa5
; CHECK-NEXT:    vmfgt.vf v9, v12, fa5
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_one_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v12, fa5
; CHECK-NEXT:    vmflt.vf v9, v12, fa5
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_one_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_one_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_ord_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v10, v12, v12
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v8, v12, v12
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ord_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa5
; CHECK-NEXT:    vmfeq.vf v10, v12, fa5
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v8, v12, v12
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ord_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa5
; CHECK-NEXT:    vmfeq.vf v10, v12, fa5
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v8, v12, v12
; CHECK-NEXT:    vmand.mm v0, v10, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_ord_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v10, v12, v12
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v8, v12, v12
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_ord_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa5
; CHECK-NEXT:    vmfeq.vf v10, v12, fa5
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v8, v12, v12
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_ueq_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v16, v12
; CHECK-NEXT:    vmflt.vv v9, v12, v16
; CHECK-NEXT:    vmnor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ueq_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v12, fa5
; CHECK-NEXT:    vmfgt.vf v9, v12, fa5
; CHECK-NEXT:    vmnor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ueq_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v12, fa5
; CHECK-NEXT:    vmflt.vf v9, v12, fa5
; CHECK-NEXT:    vmnor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_ueq_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_ueq_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_ugt_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v16, v12
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ugt_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v12, fa5
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ugt_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v12, fa5
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_ugt_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_ugt_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_uge_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v16, v12
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_uge_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v12, fa5
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_uge_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v12, fa5
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_uge_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_uge_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_ult_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v16, v12
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ult_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v12, fa5
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ult_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v12, fa5
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_ult_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_ult_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_ule_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v16, v12
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ule_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v12, fa5
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_ule_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v12, fa5
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_ule_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_ule_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_une_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_une_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_une_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_une_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v16, v12
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_une_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v12, fa5
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8bf16(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) {
; CHECK-LABEL: fcmp_uno_vv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v10, v12, v12
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v12, v12
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_uno_vf_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa5
; CHECK-NEXT:    vmfne.vf v10, v12, fa5
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v12, v12
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_fv_nxv8bf16(<vscale x 8 x bfloat> %va, bfloat %b) {
; CHECK-LABEL: fcmp_uno_fv_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa5
; CHECK-NEXT:    vmfne.vf v10, v12, fa5
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v12, v12
; CHECK-NEXT:    vmor.mm v0, v10, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x bfloat> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, <vscale x 8 x bfloat> %vb) #0 {
; CHECK-LABEL: fcmp_uno_vv_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v10, v12, v12
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v12, v12
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x bfloat> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8bf16_nonans(<vscale x 8 x bfloat> %va, bfloat %b) #0 {
; CHECK-LABEL: fcmp_uno_vf_nxv8bf16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa0
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa5
; CHECK-NEXT:    vmfne.vf v10, v12, fa5
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v8, v12, v12
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %b, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x bfloat> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_oeq_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_oeq_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_oeq_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_oeq_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_oeq_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_ogt_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v10, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ogt_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfgt.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ogt_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_ogt_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v10, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_ogt_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfgt.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_oge_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v10, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_oge_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfge.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_oge_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_oge_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v10, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_oge_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfge.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_olt_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_olt_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_olt_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfgt.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_olt_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_olt_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_ole_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ole_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ole_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfge.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_ole_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_ole_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_one_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v8, v10
; ZVFH-NEXT:    vmflt.vv v13, v10, v8
; ZVFH-NEXT:    vmor.mm v0, v13, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12
; ZVFHMIN-NEXT:    vmflt.vv v9, v12, v16
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %vc = fcmp one <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_one_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0
; ZVFH-NEXT:    vmfgt.vf v11, v8, fa0
; ZVFH-NEXT:    vmor.mm v0, v11, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmfgt.vf v9, v12, fa5
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_one_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0
; ZVFH-NEXT:    vmflt.vf v11, v8, fa0
; ZVFH-NEXT:    vmor.mm v0, v11, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfgt.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmflt.vf v9, v12, fa5
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_one_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp one <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_one_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_ord_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vv v12, v10, v10
; ZVFH-NEXT:    vmfeq.vv v10, v8, v8
; ZVFH-NEXT:    vmand.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v10, v12, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ord_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vmfeq.vf v12, v10, fa0
; ZVFH-NEXT:    vmfeq.vv v10, v8, v8
; ZVFH-NEXT:    vmand.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vmfeq.vf v10, v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ord_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vmfeq.vf v12, v10, fa0
; ZVFH-NEXT:    vmfeq.vv v10, v8, v8
; ZVFH-NEXT:    vmand.mm v0, v12, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vmfeq.vf v10, v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmand.mm v0, v10, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_ord_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vv v12, v10, v10
; ZVFH-NEXT:    vmfeq.vv v10, v8, v8
; ZVFH-NEXT:    vmand.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v10, v12, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_ord_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vmfeq.vf v12, v10, fa0
; ZVFH-NEXT:    vmfeq.vv v10, v8, v8
; ZVFH-NEXT:    vmand.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vmfeq.vf v10, v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_ueq_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v8, v10
; ZVFH-NEXT:    vmflt.vv v13, v10, v8
; ZVFH-NEXT:    vmnor.mm v0, v13, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12
; ZVFHMIN-NEXT:    vmflt.vv v9, v12, v16
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ueq_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0
; ZVFH-NEXT:    vmfgt.vf v11, v8, fa0
; ZVFH-NEXT:    vmnor.mm v0, v11, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmfgt.vf v9, v12, fa5
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ueq_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0
; ZVFH-NEXT:    vmflt.vf v11, v8, fa0
; ZVFH-NEXT:    vmnor.mm v0, v11, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfgt.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmflt.vf v9, v12, fa5
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_ueq_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_ueq_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfeq.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_ugt_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v12, v8, v10
; ZVFH-NEXT:    vmnot.m v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ugt_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v10, v8, fa0
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ugt_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v10, v8, fa0
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfge.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_ugt_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v10, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_ugt_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfgt.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_uge_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v8, v10
; ZVFH-NEXT:    vmnot.m v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_uge_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_uge_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfgt.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_uge_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v10, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_uge_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfge.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_ult_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v12, v10, v8
; ZVFH-NEXT:    vmnot.m v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v16, v12
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ult_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfge.vf v10, v8, fa0
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfge.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ult_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v10, v8, fa0
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_ult_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_ult_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_ule_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vv v12, v10, v8
; ZVFH-NEXT:    vmnot.m v0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v16, v12
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ule_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfgt.vf v10, v8, fa0
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfgt.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_ule_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmflt.vf v10, v8, fa0
; ZVFH-NEXT:    vmnot.m v0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmflt.vf v8, v12, fa5
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_ule_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_ule_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfle.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfle.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_une_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp une <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_une_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_une_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_une_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vv v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v0, v16, v12
; ZVFHMIN-NEXT:    ret
  %vc = fcmp une <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_une_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vf v0, v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vf v0, v12, fa5
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; ZVFH-LABEL: fcmp_uno_vv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vv v12, v10, v10
; ZVFH-NEXT:    vmfne.vv v10, v8, v8
; ZVFH-NEXT:    vmor.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v10, v12, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_uno_vf_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vmfne.vf v12, v10, fa0
; ZVFH-NEXT:    vmfne.vv v10, v8, v8
; ZVFH-NEXT:    vmor.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vf_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vmfne.vf v10, v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; ZVFH-LABEL: fcmp_uno_fv_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vmfne.vf v12, v10, fa0
; ZVFH-NEXT:    vmfne.vv v10, v8, v8
; ZVFH-NEXT:    vmor.mm v0, v12, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_fv_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vmfne.vf v10, v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmor.mm v0, v10, v8
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; ZVFH-LABEL: fcmp_uno_vv_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmfne.vv v12, v10, v10
; ZVFH-NEXT:    vmfne.vv v10, v8, v8
; ZVFH-NEXT:    vmor.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vv_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v10, v12, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; ZVFH-LABEL: fcmp_uno_vf_nxv8f16_nonans:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v10, fa0
; ZVFH-NEXT:    vmfne.vf v12, v10, fa0
; ZVFH-NEXT:    vmfne.vv v10, v8, v8
; ZVFH-NEXT:    vmor.mm v0, v10, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vf_nxv8f16_nonans:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v12, fa5
; ZVFHMIN-NEXT:    vmfne.vf v10, v12, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v12
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_oeq_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ogt_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_oge_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_oge_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_oge_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_oge_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_oge_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_olt_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_olt_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_olt_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_olt_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_olt_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ole_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ole_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ole_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ole_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ole_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_one_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmflt.vv v17, v12, v8
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_one_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_one_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmflt.vf v13, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_one_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_one_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ord_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ord_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ord_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ord_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ord_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmflt.vv v17, v12, v8
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ueq_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmflt.vf v13, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v8, v12
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ugt_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_uge_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_uge_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_uge_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_uge_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_uge_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ult_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ult_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ult_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ult_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ult_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ule_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v12, v8
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ule_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ule_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ule_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ule_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_une_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_une_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_une_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_une_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_une_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_uno_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v12, v12
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_uno_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfne.vf v16, v12, fa0
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_uno_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfne.vf v16, v12, fa0
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_uno_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v12, v12
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_uno_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfne.vf v16, v12, fa0
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_oeq_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ogt_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_oge_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_oge_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_oge_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_oge_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_oge_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_olt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_olt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_olt_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_olt_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_olt_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ole_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ole_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ole_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ole_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ole_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_one_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_one_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_one_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_one_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_one_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ord_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v24, v16, v16
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ord_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfeq.vf v24, v16, fa0
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ord_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfeq.vf v24, v16, fa0
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v24, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ord_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v24, v16, v16
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ord_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfeq.vf v24, v16, fa0
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmnor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ueq_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v8, v16
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ugt_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_uge_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_uge_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_uge_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_uge_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_uge_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ult_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ult_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ult_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ult_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ult_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ule_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v16, v8
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ule_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ule_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ule_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ule_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_une_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_une_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_une_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_une_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_une_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_uno_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vv v24, v16, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vmor.mm v0, v16, v24
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_uno_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfne.vf v24, v16, fa0
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vmor.mm v0, v16, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_uno_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfne.vf v24, v16, fa0
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vmor.mm v0, v24, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_uno_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfne.vv v24, v16, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vmor.mm v0, v16, v24
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_uno_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfne.vf v24, v16, fa0
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vmor.mm v0, v16, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

; This fcmp/setcc is split and so we find a scalable-vector mask CONCAT_VECTOR
; node. Ensure we correctly (custom) lower this.
define <vscale x 16 x i1> @fcmp_oeq_vf_nx16f64(<vscale x 16 x double> %va) {
; RV32-LABEL: fcmp_oeq_vf_nx16f64:
; RV32:       # %bb.0:
; RV32-NEXT:    fcvt.d.w fa5, zero
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32-NEXT:    vmfeq.vf v24, v16, fa5
; RV32-NEXT:    vmfeq.vf v0, v8, fa5
; RV32-NEXT:    srli a0, a0, 3
; RV32-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; RV32-NEXT:    vslideup.vx v0, v24, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: fcmp_oeq_vf_nx16f64:
; RV64:       # %bb.0:
; RV64-NEXT:    fmv.d.x fa5, zero
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64-NEXT:    vmfeq.vf v24, v16, fa5
; RV64-NEXT:    vmfeq.vf v0, v8, fa5
; RV64-NEXT:    srli a0, a0, 3
; RV64-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; RV64-NEXT:    vslideup.vx v0, v24, a0
; RV64-NEXT:    ret
;
; ZVFHMIN32-LABEL: fcmp_oeq_vf_nx16f64:
; ZVFHMIN32:       # %bb.0:
; ZVFHMIN32-NEXT:    fcvt.d.w fa5, zero
; ZVFHMIN32-NEXT:    csrr a0, vlenb
; ZVFHMIN32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; ZVFHMIN32-NEXT:    vmfeq.vf v24, v16, fa5
; ZVFHMIN32-NEXT:    vmfeq.vf v0, v8, fa5
; ZVFHMIN32-NEXT:    srli a0, a0, 3
; ZVFHMIN32-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; ZVFHMIN32-NEXT:    vslideup.vx v0, v24, a0
; ZVFHMIN32-NEXT:    ret
;
; ZVFHMIN64-LABEL: fcmp_oeq_vf_nx16f64:
; ZVFHMIN64:       # %bb.0:
; ZVFHMIN64-NEXT:    fmv.d.x fa5, zero
; ZVFHMIN64-NEXT:    csrr a0, vlenb
; ZVFHMIN64-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; ZVFHMIN64-NEXT:    vmfeq.vf v24, v16, fa5
; ZVFHMIN64-NEXT:    vmfeq.vf v0, v8, fa5
; ZVFHMIN64-NEXT:    srli a0, a0, 3
; ZVFHMIN64-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; ZVFHMIN64-NEXT:    vslideup.vx v0, v24, a0
; ZVFHMIN64-NEXT:    ret
  %vc = fcmp oeq <vscale x 16 x double> %va, zeroinitializer
  ret <vscale x 16 x i1> %vc
}

attributes #0 = { "no-nans-fp-math"="true" }
