; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=s390x-linux < %s | FileCheck %s -check-prefix=SOFT-FLOAT

define float @fmuladd_intrinsic_f32(float %a, float %b, float %c) #0 {
; SOFT-FLOAT-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT:       # %bb.0:
; SOFT-FLOAT-NEXT:    stmg %r13, %r15, 104(%r15)
; SOFT-FLOAT-NEXT:    .cfi_offset %r13, -56
; SOFT-FLOAT-NEXT:    .cfi_offset %r14, -48
; SOFT-FLOAT-NEXT:    .cfi_offset %r15, -40
; SOFT-FLOAT-NEXT:    aghi %r15, -160
; SOFT-FLOAT-NEXT:    .cfi_def_cfa_offset 320
; SOFT-FLOAT-NEXT:    llgfr %r2, %r2
; SOFT-FLOAT-NEXT:    llgfr %r3, %r3
; SOFT-FLOAT-NEXT:    lr %r13, %r4
; SOFT-FLOAT-NEXT:    brasl %r14, __mulsf3@PLT
; SOFT-FLOAT-NEXT:    llgfr %r3, %r13
; SOFT-FLOAT-NEXT:    brasl %r14, __addsf3@PLT
; SOFT-FLOAT-NEXT:    # kill: def $r2l killed $r2l killed $r2d
; SOFT-FLOAT-NEXT:    lmg %r13, %r15, 264(%r15)
; SOFT-FLOAT-NEXT:    br %r14
  %result = call float @llvm.fmuladd.f32(float %a, float %b, float %c)
  ret float %result
}

define double @fmuladd_intrinsic_f64(double %a, double %b, double %c) #0 {
; SOFT-FLOAT-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT:       # %bb.0:
; SOFT-FLOAT-NEXT:    stmg %r13, %r15, 104(%r15)
; SOFT-FLOAT-NEXT:    .cfi_offset %r13, -56
; SOFT-FLOAT-NEXT:    .cfi_offset %r14, -48
; SOFT-FLOAT-NEXT:    .cfi_offset %r15, -40
; SOFT-FLOAT-NEXT:    aghi %r15, -160
; SOFT-FLOAT-NEXT:    .cfi_def_cfa_offset 320
; SOFT-FLOAT-NEXT:    lgr %r13, %r4
; SOFT-FLOAT-NEXT:    brasl %r14, __muldf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r3, %r13
; SOFT-FLOAT-NEXT:    brasl %r14, __adddf3@PLT
; SOFT-FLOAT-NEXT:    lmg %r13, %r15, 264(%r15)
; SOFT-FLOAT-NEXT:    br %r14
  %result = call double @llvm.fmuladd.f64(double %a, double %b, double %c)
  ret double %result
}

define float @fmuladd_contract_f32(float %a, float %b, float %c) #0 {
; SOFT-FLOAT-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT:       # %bb.0:
; SOFT-FLOAT-NEXT:    stmg %r13, %r15, 104(%r15)
; SOFT-FLOAT-NEXT:    .cfi_offset %r13, -56
; SOFT-FLOAT-NEXT:    .cfi_offset %r14, -48
; SOFT-FLOAT-NEXT:    .cfi_offset %r15, -40
; SOFT-FLOAT-NEXT:    aghi %r15, -160
; SOFT-FLOAT-NEXT:    .cfi_def_cfa_offset 320
; SOFT-FLOAT-NEXT:    llgfr %r2, %r2
; SOFT-FLOAT-NEXT:    llgfr %r3, %r3
; SOFT-FLOAT-NEXT:    lr %r13, %r4
; SOFT-FLOAT-NEXT:    brasl %r14, __mulsf3@PLT
; SOFT-FLOAT-NEXT:    llgfr %r3, %r13
; SOFT-FLOAT-NEXT:    brasl %r14, __addsf3@PLT
; SOFT-FLOAT-NEXT:    # kill: def $r2l killed $r2l killed $r2d
; SOFT-FLOAT-NEXT:    lmg %r13, %r15, 264(%r15)
; SOFT-FLOAT-NEXT:    br %r14
  %product = fmul contract float %a, %b
  %result = fadd contract float %product, %c
  ret float %result
}

define double @fmuladd_contract_f64(double %a, double %b, double %c) #0 {
; SOFT-FLOAT-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT:       # %bb.0:
; SOFT-FLOAT-NEXT:    stmg %r13, %r15, 104(%r15)
; SOFT-FLOAT-NEXT:    .cfi_offset %r13, -56
; SOFT-FLOAT-NEXT:    .cfi_offset %r14, -48
; SOFT-FLOAT-NEXT:    .cfi_offset %r15, -40
; SOFT-FLOAT-NEXT:    aghi %r15, -160
; SOFT-FLOAT-NEXT:    .cfi_def_cfa_offset 320
; SOFT-FLOAT-NEXT:    lgr %r13, %r4
; SOFT-FLOAT-NEXT:    brasl %r14, __muldf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r3, %r13
; SOFT-FLOAT-NEXT:    brasl %r14, __adddf3@PLT
; SOFT-FLOAT-NEXT:    lmg %r13, %r15, 264(%r15)
; SOFT-FLOAT-NEXT:    br %r14
  %product = fmul contract double %a, %b
  %result = fadd contract double %product, %c
  ret double %result
}

define <4 x float> @fmuladd_contract_v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c) #0 {
; SOFT-FLOAT-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT:       # %bb.0:
; SOFT-FLOAT-NEXT:    stmg %r7, %r15, 56(%r15)
; SOFT-FLOAT-NEXT:    .cfi_offset %r7, -104
; SOFT-FLOAT-NEXT:    .cfi_offset %r8, -96
; SOFT-FLOAT-NEXT:    .cfi_offset %r9, -88
; SOFT-FLOAT-NEXT:    .cfi_offset %r10, -80
; SOFT-FLOAT-NEXT:    .cfi_offset %r11, -72
; SOFT-FLOAT-NEXT:    .cfi_offset %r12, -64
; SOFT-FLOAT-NEXT:    .cfi_offset %r13, -56
; SOFT-FLOAT-NEXT:    .cfi_offset %r14, -48
; SOFT-FLOAT-NEXT:    .cfi_offset %r15, -40
; SOFT-FLOAT-NEXT:    aghi %r15, -176
; SOFT-FLOAT-NEXT:    .cfi_def_cfa_offset 336
; SOFT-FLOAT-NEXT:    llgf %r0, 388(%r15)
; SOFT-FLOAT-NEXT:    stg %r0, 168(%r15) # 8-byte Folded Spill
; SOFT-FLOAT-NEXT:    llgf %r0, 380(%r15)
; SOFT-FLOAT-NEXT:    stg %r0, 160(%r15) # 8-byte Folded Spill
; SOFT-FLOAT-NEXT:    llgf %r11, 372(%r15)
; SOFT-FLOAT-NEXT:    llgf %r10, 364(%r15)
; SOFT-FLOAT-NEXT:    llgf %r8, 340(%r15)
; SOFT-FLOAT-NEXT:    llgf %r0, 356(%r15)
; SOFT-FLOAT-NEXT:    llgf %r7, 348(%r15)
; SOFT-FLOAT-NEXT:    llgfr %r1, %r5
; SOFT-FLOAT-NEXT:    lr %r9, %r4
; SOFT-FLOAT-NEXT:    lr %r13, %r3
; SOFT-FLOAT-NEXT:    lr %r12, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r1
; SOFT-FLOAT-NEXT:    lgr %r3, %r0
; SOFT-FLOAT-NEXT:    brasl %r14, __mulsf3@PLT
; SOFT-FLOAT-NEXT:    llgfr %r0, %r9
; SOFT-FLOAT-NEXT:    lgr %r9, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r0
; SOFT-FLOAT-NEXT:    lgr %r3, %r7
; SOFT-FLOAT-NEXT:    brasl %r14, __mulsf3@PLT
; SOFT-FLOAT-NEXT:    llgfr %r0, %r13
; SOFT-FLOAT-NEXT:    lgr %r13, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r0
; SOFT-FLOAT-NEXT:    lgr %r3, %r8
; SOFT-FLOAT-NEXT:    brasl %r14, __mulsf3@PLT
; SOFT-FLOAT-NEXT:    llgfr %r0, %r12
; SOFT-FLOAT-NEXT:    llgfr %r3, %r6
; SOFT-FLOAT-NEXT:    lgr %r12, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r0
; SOFT-FLOAT-NEXT:    brasl %r14, __mulsf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r3, %r10
; SOFT-FLOAT-NEXT:    brasl %r14, __addsf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r10, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r12
; SOFT-FLOAT-NEXT:    lgr %r3, %r11
; SOFT-FLOAT-NEXT:    brasl %r14, __addsf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r12, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r13
; SOFT-FLOAT-NEXT:    lg %r3, 160(%r15) # 8-byte Folded Reload
; SOFT-FLOAT-NEXT:    brasl %r14, __addsf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r13, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r9
; SOFT-FLOAT-NEXT:    lg %r3, 168(%r15) # 8-byte Folded Reload
; SOFT-FLOAT-NEXT:    brasl %r14, __addsf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r5, %r2
; SOFT-FLOAT-NEXT:    lr %r2, %r10
; SOFT-FLOAT-NEXT:    lr %r3, %r12
; SOFT-FLOAT-NEXT:    lr %r4, %r13
; SOFT-FLOAT-NEXT:    # kill: def $r5l killed $r5l killed $r5d
; SOFT-FLOAT-NEXT:    lmg %r7, %r15, 232(%r15)
; SOFT-FLOAT-NEXT:    br %r14
  %product = fmul contract <4 x float> %a, %b
  %result = fadd contract <4 x float> %product, %c
  ret <4 x float> %result
}

define <4 x double> @fmuladd_contract_v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %c) #0 {
; SOFT-FLOAT-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT:       # %bb.0:
; SOFT-FLOAT-NEXT:    stmg %r6, %r15, 48(%r15)
; SOFT-FLOAT-NEXT:    .cfi_offset %r6, -112
; SOFT-FLOAT-NEXT:    .cfi_offset %r7, -104
; SOFT-FLOAT-NEXT:    .cfi_offset %r8, -96
; SOFT-FLOAT-NEXT:    .cfi_offset %r9, -88
; SOFT-FLOAT-NEXT:    .cfi_offset %r10, -80
; SOFT-FLOAT-NEXT:    .cfi_offset %r11, -72
; SOFT-FLOAT-NEXT:    .cfi_offset %r12, -64
; SOFT-FLOAT-NEXT:    .cfi_offset %r13, -56
; SOFT-FLOAT-NEXT:    .cfi_offset %r14, -48
; SOFT-FLOAT-NEXT:    .cfi_offset %r15, -40
; SOFT-FLOAT-NEXT:    aghi %r15, -184
; SOFT-FLOAT-NEXT:    .cfi_def_cfa_offset 344
; SOFT-FLOAT-NEXT:    mvc 176(8,%r15), 24(%r4) # 8-byte Folded Spill
; SOFT-FLOAT-NEXT:    mvc 168(8,%r15), 16(%r4) # 8-byte Folded Spill
; SOFT-FLOAT-NEXT:    mvc 160(8,%r15), 8(%r4) # 8-byte Folded Spill
; SOFT-FLOAT-NEXT:    lg %r10, 0(%r4)
; SOFT-FLOAT-NEXT:    lg %r9, 0(%r2)
; SOFT-FLOAT-NEXT:    lg %r8, 0(%r3)
; SOFT-FLOAT-NEXT:    lg %r7, 8(%r2)
; SOFT-FLOAT-NEXT:    lg %r6, 8(%r3)
; SOFT-FLOAT-NEXT:    lg %r13, 16(%r2)
; SOFT-FLOAT-NEXT:    lg %r2, 24(%r2)
; SOFT-FLOAT-NEXT:    lg %r0, 24(%r3)
; SOFT-FLOAT-NEXT:    lg %r12, 16(%r3)
; SOFT-FLOAT-NEXT:    lgr %r3, %r0
; SOFT-FLOAT-NEXT:    brasl %r14, __muldf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r11, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r13
; SOFT-FLOAT-NEXT:    lgr %r3, %r12
; SOFT-FLOAT-NEXT:    brasl %r14, __muldf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r13, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r7
; SOFT-FLOAT-NEXT:    lgr %r3, %r6
; SOFT-FLOAT-NEXT:    brasl %r14, __muldf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r12, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r9
; SOFT-FLOAT-NEXT:    lgr %r3, %r8
; SOFT-FLOAT-NEXT:    brasl %r14, __muldf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r3, %r10
; SOFT-FLOAT-NEXT:    brasl %r14, __adddf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r10, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r12
; SOFT-FLOAT-NEXT:    lg %r3, 160(%r15) # 8-byte Folded Reload
; SOFT-FLOAT-NEXT:    brasl %r14, __adddf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r12, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r13
; SOFT-FLOAT-NEXT:    lg %r3, 168(%r15) # 8-byte Folded Reload
; SOFT-FLOAT-NEXT:    brasl %r14, __adddf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r13, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r11
; SOFT-FLOAT-NEXT:    lg %r3, 176(%r15) # 8-byte Folded Reload
; SOFT-FLOAT-NEXT:    brasl %r14, __adddf3@PLT
; SOFT-FLOAT-NEXT:    lgr %r5, %r2
; SOFT-FLOAT-NEXT:    lgr %r2, %r10
; SOFT-FLOAT-NEXT:    lgr %r3, %r12
; SOFT-FLOAT-NEXT:    lgr %r4, %r13
; SOFT-FLOAT-NEXT:    lmg %r6, %r15, 232(%r15)
; SOFT-FLOAT-NEXT:    br %r14
  %product = fmul contract <4 x double> %a, %b
  %result = fadd contract <4 x double> %product, %c
  ret <4 x double> %result
}

attributes #0 = { "use-soft-float"="true" }

declare float @llvm.fmuladd.f32(float %a, float %b, float %c)
declare double @llvm.fmuladd.f64(double %a, double %b, double %c)
