if [ $(uname -m) = "x86_64" ]
then
	POSTFIX="win64"
else
	POSTFIX="win32"
fi
VERSION=$(cat /etc/libopenh264/version.txt)
cd /tmp
wget -q http://ciscobinary.openh264.org/openh264-${VERSION}-${POSTFIX}.dll.bz2 -O - | bunzip2 > openh264-${VERSION}-${POSTFIX}.tmp
if sha256sum --status -c /etc/libopenh264/openh264-${VERSION}-${POSTFIX}.dll.sha256
then
	mv openh264-${VERSION}-${POSTFIX}.tmp /usr/bin/libopenh264.dll
else
	# Hash mismatch (or failed to download)
	rm openh264-${VERSION}-${POSTFIX}.tmp
	exit 1
fi
chmod a+x /usr/bin/libopenh264.dll
