










use std::iter;












pub(crate) fn enumerate<I>(iterable: I) -> iter::Enumerate<I::IntoIter>
where I: IntoIterator
{
    iterable.into_iter().enumerate()
}













pub(crate) fn zip<I, J>(i: I, j: J) -> iter::Zip<I::IntoIter, J::IntoIter>
where
    I: IntoIterator,
    J: IntoIterator,
{
    i.into_iter().zip(j)
}




















/// #[macro_use] extern crate itertools;
/// # fn main() {










/// # }


/// **Note:** To enable the macros in this crate, use the `#[macro_use]`



/// # #[allow(unused_imports)]
/// #[macro_use] extern crate itertools;
/// # fn main() { }

macro_rules! izip {
    
    
    
    ( @closure $p:pat => $tup:expr ) => {
        |$p| $tup
    };

    
    ( @closure $p:pat => ( $($tup:tt)* ) , $_iter:expr $( , $tail:expr )* ) => {
        izip!(@closure ($p, b) => ( $($tup)*, b ) $( , $tail )*)
    };

    
    ($first:expr $(,)*) => {
        IntoIterator::into_iter($first)
    };

    
    ($first:expr, $second:expr $(,)*) => {
        izip!($first)
            .zip($second)
    };

    
    ( $first:expr $( , $rest:expr )* $(,)* ) => {
        izip!($first)
            $(
                .zip($rest)
            )*
            .map(
                izip!(@closure a => (a) $( , $rest )*)
            )
    };
}
