% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_similarities.R
\name{jaccard_similarity}
\alias{jaccard_similarity}
\title{Calculate Jaccard Similarity of two character vectors}
\usage{
jaccard_similarity(a, b, ngram_width = 2, nthread = NULL)
}
\arguments{
\item{a}{the first character vector}

\item{b}{the first character vector}

\item{ngram_width}{the length of the shingles / ngrams used in the
similarity calculation}

\item{nthread}{Maximum number of threads to use. If \code{NULL} (default),
Rayon's global thread pool is used, which typically uses all logical
CPU cores available.}
}
\value{
a vector of jaccard similarities of the strings
}
\description{
Calculate Jaccard Similarity of two character vectors
}
\examples{
jaccard_similarity(
  c("the quick brown fox", "jumped over the lazy dog"),
  c("the quck bron fx", "jumped over hte lazy dog")
)

}
