% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modavg_xpdb.R
\name{modavg_xpdb}
\alias{modavg_xpdb}
\title{Create a model-averaged xpose data object}
\usage{
modavg_xpdb(
  xpdb_s,
  ...,
  .lineage = FALSE,
  avg_cols = NULL,
  avg_by_type = NULL,
  algorithm = c("maa", "msa"),
  weight_type = c("individual", "population"),
  auto_backfill = FALSE,
  weight_basis = c("ofv", "aic", "res"),
  res_col = "RES",
  quiet
)
}
\arguments{
\item{xpdb_s}{<\code{xpose_set}> object}

\item{...}{<\code{tidyselect}> of models in set. If empty, all models are
used in order of their position in the set. May also use a formula,
which will just be processed with \code{all.vars()}.}

\item{.lineage}{<\code{logical}> where if \code{TRUE}, \code{...} is processed}

\item{avg_cols}{<\code{tidyselect}> columns in data to average}

\item{avg_by_type}{<\code{character}> Mainly for use in wrapper functions.
Column type to average, but resulting column names must be valid
for \code{avg_cols} (ie, same across all objects in the set). \code{avg_cols} will
be overwritten.}

\item{algorithm}{<\code{character}> Model selection or model averaging}

\item{weight_type}{<\code{character}> Individual-level averaging or by full dataset.}

\item{auto_backfill}{<\code{logical}> If true, <\code{\link{backfill_iofv}}> is automatically
applied.}

\item{weight_basis}{<\code{character}> Weigh by OFV (default), AIC or residual.}

\item{res_col}{<\code{character}> Column to weight by if \code{"res"} weight basis.}

\item{quiet}{<\code{logical}> Minimize extra output.}
}
\value{
Weight-averaged <\code{xpose_data}> object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function is a helper for plotting functions where models in
an \code{xpose_set} can be averaged together. The implementation attempts
to match and extend from the cited prior work.
}
\examples{

pheno_set \%>\%
  modavg_xpdb(
    avg_cols = IPRED,
    auto_backfill = TRUE,
    algorithm = "maa",
    weight_basis = "aic"
  )

}
\references{
Uster, D.W., Stocker, S.L., Carland, J.E., Brett, J., Marriott, D.J.E.,
Day, R.O. and Wicha, S.G. (2021), A Model Averaging/Selection Approach
Improves the Predictive Performance of Model-Informed Precision Dosing:
Vancomycin as a Case Study. Clin. Pharmacol. Ther., 109: 175-183.
\doi{doi:10.1002/cpt.2065}
}
