% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate-pvalues.R
\name{calc_prob_null}
\alias{calc_prob_null}
\title{Calculate probability for given parameters}
\usage{
calc_prob_null(theta_cands, SSpacearr, logC, II)
}
\arguments{
\item{theta_cands}{A matrix with samples in the rows and the parameters in
the columns}

\item{SSpacearr}{A matrix with the sample space for the given size of the
problem}

\item{logC}{log multinomial coefficient for each element of the sample space}

\item{II}{logical vector of statistic for elements of sample space statistic being more extreme than the
observed statistic}
}
\value{
A numeric vector of probabilities
}
\description{
Given a set of candidate parameter vectors, the enumerated sample space, and a
logical vector with the same number of elements of the sample space, compute
the probability for each element of the sample space and take the sum.
}
\examples{
sspace_3_5 <- matrix(sspace_multinom(3, 5), ncol = 3, byrow = TRUE)
theta_cands <- matrix(sample_unit_simplexn(3, 10), ncol = 3,byrow = TRUE)
calc_prob_null_fast(theta_cands, sspace_3_5,
apply(sspace_3_5, 1, log_multinom_coef, sumx = 5), II = 1:21 > 12)
# same as below but faster
calc_prob_null(theta_cands, sspace_3_5,
apply(sspace_3_5, 1, log_multinom_coef, sumx = 5), II = 1:21 > 12)

}
