% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_breach_depressions}
\alias{wbt_breach_depressions}
\title{Breach depressions}
\usage{
wbt_breach_depressions(
  dem,
  output,
  max_depth = NULL,
  max_length = NULL,
  flat_increment = NULL,
  fill_pits = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{max_depth}{Optional maximum breach depth (default is Inf).}

\item{max_length}{Optional maximum breach channel length (in grid cells; default is Inf).}

\item{flat_increment}{Optional elevation increment applied to flat areas.}

\item{fill_pits}{Optional flag indicating whether to fill single-cell pits.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Breaches all of the depressions in a DEM using Lindsay's (2016) algorithm. This should be preferred over depression filling in most cases.
}
\keyword{HydrologicalAnalysis}
