% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapter-crul.R, R/adapter-httr.R,
%   R/adapter-httr2.R, R/adapter.R
\name{CrulAdapter}
\alias{CrulAdapter}
\alias{HttrAdapter}
\alias{Httr2Adapter}
\alias{Adapter}
\title{Adapters for Modifying HTTP Requests}
\description{
\code{Adapter} is the base parent class used to implement
\pkg{webmockr} support for different HTTP clients. It should not be used
directly. Instead, use one of the client-specific adapters that webmockr
currently provides:
\itemize{
\item \code{CrulAdapter} for \pkg{crul}
\item \code{HttrAdapter} for \pkg{httr}
\item \code{Httr2Adapter} for \pkg{httr2}
}
}
\details{
Note that the documented fields and methods are the same across all
client-specific adapters.
}
\keyword{internal}
\section{Super class}{
\code{\link[webmockr:Adapter]{webmockr::Adapter}} -> \code{CrulAdapter}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{client}}{HTTP client package name}

\item{\code{name}}{adapter name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CrulAdapter-clone}{\code{CrulAdapter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="disable"><a href='../../webmockr/html/Adapter.html#method-Adapter-disable'><code>webmockr::Adapter$disable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="enable"><a href='../../webmockr/html/Adapter.html#method-Adapter-enable'><code>webmockr::Adapter$enable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="handle_request"><a href='../../webmockr/html/Adapter.html#method-Adapter-handle_request'><code>webmockr::Adapter$handle_request()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="initialize"><a href='../../webmockr/html/Adapter.html#method-Adapter-initialize'><code>webmockr::Adapter$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="remove_stubs"><a href='../../webmockr/html/Adapter.html#method-Adapter-remove_stubs'><code>webmockr::Adapter$remove_stubs()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CrulAdapter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CrulAdapter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CrulAdapter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[webmockr:Adapter]{webmockr::Adapter}} -> \code{HttrAdapter}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{client}}{HTTP client package name}

\item{\code{name}}{adapter name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HttrAdapter-clone}{\code{HttrAdapter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="disable"><a href='../../webmockr/html/Adapter.html#method-Adapter-disable'><code>webmockr::Adapter$disable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="enable"><a href='../../webmockr/html/Adapter.html#method-Adapter-enable'><code>webmockr::Adapter$enable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="handle_request"><a href='../../webmockr/html/Adapter.html#method-Adapter-handle_request'><code>webmockr::Adapter$handle_request()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="initialize"><a href='../../webmockr/html/Adapter.html#method-Adapter-initialize'><code>webmockr::Adapter$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="remove_stubs"><a href='../../webmockr/html/Adapter.html#method-Adapter-remove_stubs'><code>webmockr::Adapter$remove_stubs()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HttrAdapter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HttrAdapter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HttrAdapter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[webmockr:Adapter]{webmockr::Adapter}} -> \code{Httr2Adapter}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{client}}{HTTP client package name}

\item{\code{name}}{adapter name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Httr2Adapter-clone}{\code{Httr2Adapter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="disable"><a href='../../webmockr/html/Adapter.html#method-Adapter-disable'><code>webmockr::Adapter$disable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="enable"><a href='../../webmockr/html/Adapter.html#method-Adapter-enable'><code>webmockr::Adapter$enable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="handle_request"><a href='../../webmockr/html/Adapter.html#method-Adapter-handle_request'><code>webmockr::Adapter$handle_request()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="initialize"><a href='../../webmockr/html/Adapter.html#method-Adapter-initialize'><code>webmockr::Adapter$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="webmockr" data-topic="Adapter" data-id="remove_stubs"><a href='../../webmockr/html/Adapter.html#method-Adapter-remove_stubs'><code>webmockr::Adapter$remove_stubs()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Httr2Adapter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Httr2Adapter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Httr2Adapter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{client}}{HTTP client package name}

\item{\code{name}}{adapter name}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Adapter-new}{\code{Adapter$new()}}
\item \href{#method-Adapter-enable}{\code{Adapter$enable()}}
\item \href{#method-Adapter-disable}{\code{Adapter$disable()}}
\item \href{#method-Adapter-handle_request}{\code{Adapter$handle_request()}}
\item \href{#method-Adapter-remove_stubs}{\code{Adapter$remove_stubs()}}
\item \href{#method-Adapter-clone}{\code{Adapter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Adapter-new"></a>}}
\if{latex}{\out{\hypertarget{method-Adapter-new}{}}}
\subsection{Method \code{new()}}{
Create a new Adapter object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Adapter$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Adapter-enable"></a>}}
\if{latex}{\out{\hypertarget{method-Adapter-enable}{}}}
\subsection{Method \code{enable()}}{
Enable the adapter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Adapter$enable(quiet = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quiet}}{(logical) suppress messages? default: \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Adapter-disable"></a>}}
\if{latex}{\out{\hypertarget{method-Adapter-disable}{}}}
\subsection{Method \code{disable()}}{
Disable the adapter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Adapter$disable(quiet = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quiet}}{(logical) suppress messages? default: \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{FALSE}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Adapter-handle_request"></a>}}
\if{latex}{\out{\hypertarget{method-Adapter-handle_request}{}}}
\subsection{Method \code{handle_request()}}{
All logic for handling a request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Adapter$handle_request(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{a request}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
various outcomes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Adapter-remove_stubs"></a>}}
\if{latex}{\out{\hypertarget{method-Adapter-remove_stubs}{}}}
\subsection{Method \code{remove_stubs()}}{
Remove all stubs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Adapter$remove_stubs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing returned; removes all request stubs
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Adapter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Adapter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Adapter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
