% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is.inchikey}
\alias{is.inchikey}
\title{Check if input is a valid inchikey}
\usage{
is.inchikey(
  x,
  type = c("format", "chemspider"),
  apikey = NULL,
  verbose = getOption("verbose")
)
}
\arguments{
\item{x}{character; input InChIKey}

\item{type}{character; How should be checked? Either, by format (see above)
('format') or by ChemSpider ('chemspider').}

\item{apikey}{character; your API key. If NULL (default),
  \code{cs_check_key()} will look for it in .Renviron or .Rprofile. Only
used when `type = "chemspider"`.}

\item{verbose}{logical; print messages during processing to console?}
}
\value{
a logical
}
\description{
This function checks if a string is a valid inchikey.
Inchikey must fulfill the following criteria:
1) consist of 27 characters;
2) be all uppercase, all letters (no numbers);
3) contain two hyphens at positions 15 and 26;
4) 24th character (flag character) be 'S' (Standard InChI) or 'N' (non-standard)
5) 25th character (version character) must be 'A' (currently).
}
\note{
This function can handle only one inchikey string.
}
\examples{
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSA-N')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSA')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSA-5')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSA-n')
is.inchikey('BQJCRHHNABKAKU/KBQPJGBKSA/N')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKXA-N')
is.inchikey('BQJCRHHNABKAKU-KBQPJGBKSB-N')
}
\references{
Heller, Stephen R., et al. "InChI, the IUPAC International
Chemical Identifier." Journal of Cheminformatics 7.1 (2015): 23.

Eduard Szöcs, Tamás Stirling, Eric R. Scott, Andreas Scharmüller,
Ralf B. Schäfer (2020). webchem: An R Package to Retrieve Chemical
Information from the Web. Journal of Statistical Software, 93(13).
\doi{10.18637/jss.v093.i13}.
}
