% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layer_functions.R
\name{get_wis_rasters}
\alias{get_wis_rasters}
\title{General function to pull Raster layers from a MapServer or ImageServer}
\usage{
get_wis_rasters(
  service,
  get_raster_function,
  county = NULL,
  watershed_code = NULL,
  watershed_name = NULL,
  sf_object = NULL,
  ...
)
}
\arguments{
\item{service}{Text string describing which service to pull. Will get matched
by \code{match_services(service)}.}

\item{get_raster_function}{The \code{arcpullr} function to use: either
\code{\link[arcpullr]{get_map_layer}} or
\code{\link[arcpullr]{get_image_layer}}}

\item{county}{A character object specifying a county name}

\item{watershed_code}{A character object specifying the HUC code for a
watershed}

\item{watershed_name}{A character object specifying the HUC name for a
watershed}

\item{sf_object}{Any sf polygon object}

\item{...}{Additional arguments to pass to the \code{get_raster_function}}
}
\value{
A Raster* object dependent on \code{get_raster_function}
}
\description{
This is a non-exported function that is used as the engine for
\code{\link{get_wis_landcover}} and \code{\link{get_wis_imagery}}. It
converts watersheds, counties, etc. to the appropriate sf_object and
queries the desired service using the function specified in
\code{get_raster_function}
}
