% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{add_id_to_arcs}
\alias{add_id_to_arcs}
\title{Add Unique IDs to Arcs}
\usage{
add_id_to_arcs(arcs)
}
\arguments{
\item{arcs}{A data frame or matrix containing arc data.}
}
\value{
A data frame with an additional column `id`, representing the unique identifier for each arc.
}
\description{
This internal function adds a unique identifier to each row of an arcs data frame, where each row represents an edge.
}
\references{
Dmytrów, K. (2022). Analytical and simulation determination of order picking time in a low storage warehouse for shared storage systems. Operations Research and Decisions, 32(2), 34–51. \doi{10.37190/ord220203}

Le-Duc, T. (2005). Design and Control of Efficient Order. Erasmus Research Institute of Management (ERIM).

Tarczyński, G. (2012). Analysis of the Impact of Storage Parameters and the Size of Orders on the Choice of the Method for Routing Order Picking. Operations Research and Decisions, 22(4), 105–120. \doi{10.5277/ord120406}
}
\author{
Krzysztof Dmytrów \email{krzysztof.dmytrow@usz.edu.pl} [aut] \href{https://orcid.org/0000-0001-7657-6063}{ORCID: 0000-0001-7657-6063}

Andrzej Dudek \email{andrzej.dudek@ue.wroc.pl} [aut, cre] \href{https://orcid.org/0000-0002-4943-8703}{ORCID: 0000-0002-4943-8703}
}
\keyword{internal}
