% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sampled_split_predictions.R
\name{extract_sampled_split_predictions}
\alias{extract_sampled_split_predictions}
\title{Extract sampled-split predictions from a CV.SuperLearner object}
\usage{
extract_sampled_split_predictions(
  cvsl_obj = NULL,
  sample_splitting = TRUE,
  sample_splitting_folds = NULL,
  full = TRUE,
  preds = NULL,
  cross_fitting_folds = NULL,
  vector = TRUE
)
}
\arguments{
\item{cvsl_obj}{An object of class \code{"CV.SuperLearner"}; must be entered unless \code{preds} is specified.}

\item{sample_splitting}{logical; should we use sample-splitting or not?
Defaults to \code{TRUE}.}

\item{sample_splitting_folds}{A vector of folds to use for sample splitting}

\item{full}{logical; is this the fit to all covariates (\code{TRUE}) or not
(\code{FALSE})?}

\item{preds}{a vector of predictions; must be entered unless \code{cvsl_obj} is specified.}

\item{cross_fitting_folds}{a vector of folds that were used in cross-fitting.}

\item{vector}{logical; should we return a vector (where each element is
the prediction when the corresponding row is in the validation fold) or a
list?}
}
\value{
The predictions on validation data in each split-sample fold.
}
\description{
Use the cross-validated Super Learner and a set of specified sample-splitting
folds to extract cross-fitted predictions on separate splits of the data. This
is primarily for use in cases where you have already fit a CV.SuperLearner
and want to use the fitted values to compute variable importance without having
to re-fit. The number of folds used in the CV.SuperLearner must be even.
}
\seealso{
\code{\link[SuperLearner]{CV.SuperLearner}} for usage of the
  \code{CV.SuperLearner} function.
}
