% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oxford.R
\docType{data}
\name{oxford_general}
\alias{oxford_general}
\title{General colours of University of Oxford, England, UK}
\format{
An object of class \code{character} of length 11.
}
\source{
Colour definitions are based on the
\href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
}
\usage{
oxford_general
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{oxford_general} provides the general/ secondary colours 
of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
}
\details{
The wide secondary palette is used to add visual distinction and texture 
to design elements as well as signifying page links, 
call-to-actions (e.g buttons) and active pages in navigational elements.

The colours are
\code{"dark_blue"} (defined as HEX #001c3d),
\code{"washed_out_blue"} (defined as HEX #193658),
\code{"copyright_grey"} (defined as HEX #c7c2bc),
\code{"beige_grey"} (defined as HEX #f3f1ec),
\code{"brown_grey"} (defined as HEX #001c3d),
\code{"filter_form_green"} (defined as HEX #043946),
\code{"blue_grey"} (defined as HEX #a1c4d0),
\code{"teal"} (defined as HEX #003947),
\code{"very_light_blue"} (defined as HEX #f0f5f8),
\code{"cookie_bar"} (defined as HEX #00152e), and
\code{"blue_grey"} (defined as HEX #353c47).
}
\examples{
oxford_general
unikn::seecol(oxford_general, main = "Uni Oxford general colours") # view colour palette

}
\seealso{
\code{\link{oxford_brand}} for the brand colours of University of Oxford;
\code{\link{oxford_link}} for the link colours of University of Oxford;
\code{\link{oxford_shades}} for the shade colours of University of Oxford;
\code{\link{oxford_blog}} for the blog colours of University of Oxford;
\code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
\code{\link{oxford_error}} for the error colours of University of Oxford;
\code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
\code{\link[unikn]{seecol}} for viewing and comparing colour palettes;
\code{\link[unikn]{usecol}} for using colour palettes;
\code{\link[unikn]{simcol}} for finding similar colours;
\code{\link[unikn]{newpal}} for defining new colour palettes;
\code{\link[unikn]{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-15.
}
\concept{English university color palettes}
\keyword{datasets}
