% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bangor.R
\docType{data}
\name{bangor_1}
\alias{bangor_1}
\title{Primary corporate colours of the University of Bangor, Wales}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on \href{https://www.bangor.ac.uk}{Bangor}'s 
Brand guidelines (PDF).
}
\usage{
bangor_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{bangor_1} provides the four primary corporate colours 
of the \href{https://www.bangor.ac.uk}{University of Bangor}, Wales, UK.
}
\details{
\code{bangor_1} is based on HEX color definitions  
(see \href{https://www.bangor.ac.uk}{Bangor}'s 
Brand guidelines, PDF, p. 10, for names and details).
}
\examples{
bangor_1
unikn::seecol(bangor_1, col_bg = "grey90",  
              main = "Primary colours of the University of Bangor, Wales")  # view palette

}
\seealso{
\code{\link{bangor_2}} for secondary colours of Bangor;
\code{\link{bangor_3}} for tertiary colours of Bangor;
\code{\link{bangor_4}} for accessible web colours of Bangor;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Welsh university color palettes: 
\code{\link{aberystwyth_1}},
\code{\link{aberystwyth_2}},
\code{\link{bangor_2}},
\code{\link{bangor_3}},
\code{\link{bangor_4}},
\code{\link{cardiff_1}},
\code{\link{cardiff_2}}
}
\author{
\strong{unicol}, 2023-10-10.
}
\concept{Welsh university color palettes}
\keyword{datasets}
