% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{validate_data}
\alias{validate_data}
\title{Validate a data frame against cached metadata}
\usage{
validate_data(df, indicator_code, strict = FALSE)
}
\arguments{
\item{df}{Data frame to validate}

\item{indicator_code}{Expected indicator code}

\item{strict}{If TRUE, fail on any warning}
}
\value{
List with is_valid (logical) and issues (character vector)
}
\description{
Checks:
\itemize{
\item Indicator code exists in catalog
\item Required columns are present
\item Country codes are valid
\item Values are within expected ranges
}
}
\examples{
\dontrun{
result <- validate_data(df, "CME_MRY0T4")
if (result$is_valid) {
  message("Data is valid!")
} else {
  message("Issues found:")
  print(result$issues)
}
}
}
