% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unicef_core.R, R/zzz_aliases.R
\name{unicefData_raw}
\alias{unicefData_raw}
\alias{unicefdata_raw}
\title{Fetch Raw UNICEF Data}
\usage{
unicefData_raw(
  indicator = NULL,
  dataflow = NULL,
  countries = NULL,
  start_year = NULL,
  end_year = NULL,
  max_retries = 3,
  version = NULL,
  page_size = 1e+05,
  verbose = TRUE,
  totals = FALSE,
  labels = "id"
)

unicefdata_raw(
  indicator = NULL,
  dataflow = NULL,
  countries = NULL,
  start_year = NULL,
  end_year = NULL,
  max_retries = 3,
  version = NULL,
  page_size = 1e+05,
  verbose = TRUE,
  totals = FALSE,
  labels = "id"
)
}
\arguments{
\item{indicator}{Character vector of indicator codes.}

\item{dataflow}{Character string of dataflow ID.}

\item{countries}{Character vector of ISO3 codes.}

\item{start_year}{Numeric or character start year (YYYY).}

\item{end_year}{Numeric or character end year (YYYY).}

\item{max_retries}{Integer, number of retries for failed requests.}

\item{version}{Character string of SDMX version (e.g. "1.0").}

\item{page_size}{Integer, number of rows per page.}

\item{verbose}{Logical, print progress messages.}

\item{totals}{Logical, include total aggregations.}

\item{labels}{Character, label format ("id" or "name").}
}
\value{
A tibble of raw SDMX data, or an empty tibble if no data found.
}
\description{
Low-level fetcher for UNICEF SDMX API.
}
