% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_sync.R
\name{sync_all_metadata}
\alias{sync_all_metadata}
\title{Sync all metadata from UNICEF SDMX API}
\usage{
sync_all_metadata(
  verbose = TRUE,
  output_dir = NULL,
  include_schemas = TRUE,
  include_sample_values = TRUE
)
}
\arguments{
\item{verbose}{Print progress messages}

\item{output_dir}{Output directory (default: R/metadata/current/)}

\item{include_schemas}{Sync dataflow schemas (default: TRUE). This generates
dataflow_index.yaml and individual dataflow YAML files in dataflows/}

\item{include_sample_values}{Include sample values in schemas (default: TRUE)}
}
\value{
List with sync summary
}
\description{
Downloads dataflows, codelists, countries, regions, indicator
definitions, and optionally dataflow schemas, saving them as YAML files
with standardized watermarks.
}
\examples{
\dontrun{
# Sync all metadata including schemas
results <- sync_all_metadata()

# Sync without schemas (faster)
results <- sync_all_metadata(include_schemas = FALSE)

# Sync with custom output directory
results <- sync_all_metadata(output_dir = "./my_metadata/")
}
}
