% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_registry.R
\name{search_indicators}
\alias{search_indicators}
\title{Search Indicators}
\usage{
search_indicators(
  query = NULL,
  category = NULL,
  limit = 50,
  show_description = TRUE
)
}
\arguments{
\item{query}{Character. Search term to match in indicator code, name, or description
(case-insensitive). If NULL, shows all indicators.}

\item{category}{Character. Filter by dataflow/category (e.g., "CME", "NUTRITION").
Use list_categories() to see available categories.}

\item{limit}{Integer. Maximum number of results to display (default: 50).
Set to NULL or 0 to show all matches.}

\item{show_description}{Logical. If TRUE, includes description column (default: TRUE).}
}
\value{
Invisibly returns a data.frame with the matching indicators.
Results are also printed to the screen.
}
\description{
Search and display UNICEF indicators in a user-friendly format.
This function allows analysts to search the indicator metadata to find
indicator codes they need. Results are printed to the screen in a
formatted table.
}
\examples{
\donttest{
# Search for mortality-related indicators
search_indicators("mortality")

# List all nutrition indicators
search_indicators(category = "NUTRITION")

# Search for stunting across all categories
search_indicators("stunting")

# List all indicators (first 50)
search_indicators()

# List all CME indicators without limit
search_indicators(category = "CME", limit = 0)
}

}
