% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema_cache.R
\name{schema_cache}
\alias{schema_cache}
\title{Schema Caching System for UNICEF SDMX API}
\description{
Implements in-memory caching of SDMX metadata schemas to reduce API calls
and improve performance during interactive analysis sessions.
}
\details{
This module provides:
\itemize{
\item Session-level schema cache to avoid redundant API calls
\item Automatic expiry based on age
\item Programmatic cache invalidation
\item Cache statistics and monitoring
}
}
\examples{
\dontrun{
  # Cache is managed automatically when get_sdmx() is called with cache=TRUE

  # Manual cache operations:
  get_schema_cache_info()
  clear_schema_cache()

  # Multiple calls within session use cached schema
  df1 <- get_sdmx(indicator = "SP.POP.TOTL", cache = TRUE)
  df2 <- get_sdmx(indicator = "NY.GDP.MKTP.CD", cache = TRUE)
}

}
\keyword{internal}
