% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unicefData.R
\name{parse_year}
\alias{parse_year}
\title{Parse year parameter into start_year, end_year, and year_list}
\usage{
parse_year(year)
}
\arguments{
\item{year}{Year specification in any supported format}
}
\value{
List with start_year, end_year, and year_list components
}
\description{
Supports multiple formats for specifying years:
\itemize{
\item NULL: All years (no filtering)
\item Single integer: Just that year (e.g., 2020)
\item String with colon: Range (e.g., "2015:2023")
\item String with comma: List (e.g., "2015,2018,2020")
\item Integer vector: Explicit list of years
}
}
\examples{
parse_year(2020)
# $start_year: 2020, $end_year: 2020, $year_list: NULL

parse_year("2015:2023")
# $start_year: 2015, $end_year: 2023, $year_list: NULL

parse_year("2015,2018,2020")
# $start_year: 2015, $end_year: 2020, $year_list: c(2015, 2018, 2020)
}
