% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{list_sdmx_flows}
\alias{list_sdmx_flows}
\title{List Available SDMX Flows for an Agency}
\usage{
list_sdmx_flows(
  agency = "UNICEF",
  retry = 3L,
  cache_dir = tools::R_user_dir("unicefdata", "cache")
)
}
\arguments{
\item{agency}{Character agency ID (e.g., "UNICEF").}

\item{retry}{Number of retries for transient HTTP failures; default is 3.}

\item{cache_dir}{Directory for on-disk cache; created if it does not exist.}
}
\value{
A tibble with columns \code{id}, \code{agency}, \code{version}, and \code{name}.
}
\description{
Download and cache the SDMX dataflow definitions from a specified agency's REST endpoint.
}
